/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.presentation;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfId;
import org.odftoolkit.odfdom.dom.type.presentation.OdfEffectType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfDirectionType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfSpeedType;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.type.OdfDuration;
import org.odftoolkit.odfdom.dom.type.OdfPercent;

import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink presentation:show-shape}.
 *
 */
public abstract class OdfShowShapeElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.PRESENTATION, "show-shape" );

    /**
     * Create the instance of OdfShowShapeElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfShowShapeElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink presentation:show-shape}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfShowShapeElement}
     *
     *@param shapeId  The mandatory attribute {@attributeName  draw:shape-id}" 
     *
     */
    public void init(OdfId shapeId)
    {
        setShapeId( shapeId );
    }

    /**
     * Get value of attribute {@attributeName draw:shape-id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getShapeId()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "shape-id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:shape-id}.
     *
     *@param  shapeId    the attribute's type is OdfId
     */ 
     public void setShapeId( OdfId shapeId )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "shape-id" ), shapeId.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:effect}.
     *
     *@return return the attribute which type is OdfEffectType
     */
    public OdfEffectType getEffect()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "effect" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "none";
        }

        return OdfEffectType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:effect}.
     *
     *@param  effect    the attribute's type is OdfEffectType
     */ 
     public void setEffect( OdfEffectType effect )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "effect" ), effect.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:direction}.
     *
     *@return return the attribute which type is OdfDirectionType
     */
    public OdfDirectionType getDirection()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "direction" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "none";
        }

        return OdfDirectionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:direction}.
     *
     *@param  direction    the attribute's type is OdfDirectionType
     */ 
     public void setDirection( OdfDirectionType direction )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "direction" ), direction.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:speed}.
     *
     *@return return the attribute which type is OdfSpeedType
     */
    public OdfSpeedType getSpeed()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "speed" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "medium";
        }

        return OdfSpeedType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:speed}.
     *
     *@param  speed    the attribute's type is OdfSpeedType
     */ 
     public void setSpeed( OdfSpeedType speed )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "speed" ), speed.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:delay}.
     *
     *@return return the attribute which type is OdfDuration
     */
    public OdfDuration getDelay()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "delay" ) );
        return OdfDuration.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:delay}.
     *
     *@param  delay    the attribute's type is OdfDuration
     */ 
     public void setDelay( OdfDuration delay )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "delay" ), delay.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:start-scale}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getStartScale()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "start-scale" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "100%";
        }

        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:start-scale}.
     *
     *@param  startScale    the attribute's type is OdfPercent
     */ 
     public void setStartScale( OdfPercent startScale )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "start-scale" ), startScale.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:path-id}.
     *
     *@return return the attribute which type is String
     */
    public String getPathId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "path-id" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:path-id}.
     *
     *@param  pathId    the attribute's type is String
     */ 
     public void setPathId( String pathId )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "path-id" ), pathId );
    }

    /**
    * Create child element {@odfLink presentation:sound}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink presentation:sound}
    */
    public OdfSoundElement createSoundElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfSoundElement  nSound = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSoundElement.class);
        nSound.setHref( href);
        this.appendChild( nSound);
        return  nSound;      
    }
    
}
