/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.presentation;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.type.OdfDuration;
import org.odftoolkit.odfdom.dom.type.presentation.OdfAnimationsType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfTransitionOnClickType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink presentation:settings}.
 *
 */
public abstract class OdfSettingsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.PRESENTATION, "settings" );

    /**
     * Create the instance of OdfSettingsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSettingsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink presentation:settings}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName presentation:start-page}.
     *
     *@return return the attribute which type is String
     */
    public String getStartPage()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "start-page" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:start-page}.
     *
     *@param  startPage    the attribute's type is String
     */ 
     public void setStartPage( String startPage )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "start-page" ), startPage );
    }

    /**
     * Get value of attribute {@attributeName presentation:show}.
     *
     *@return return the attribute which type is String
     */
    public String getShow()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "show" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:show}.
     *
     *@param  show    the attribute's type is String
     */ 
     public void setShow( String show )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "show" ), show );
    }

    /**
     * Get value of attribute {@attributeName presentation:full-screen}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getFullScreen()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "full-screen" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:full-screen}.
     *
     *@param  isFullScreen    the attribute's type is OdfBoolean
     */ 
     public void setFullScreen( OdfBoolean isFullScreen )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "full-screen" ), isFullScreen.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:endless}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getEndless()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "endless" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:endless}.
     *
     *@param  isEndless    the attribute's type is OdfBoolean
     */ 
     public void setEndless( OdfBoolean isEndless )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "endless" ), isEndless.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:pause}.
     *
     *@return return the attribute which type is OdfDuration
     */
    public OdfDuration getPause()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "pause" ) );
        return OdfDuration.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:pause}.
     *
     *@param  pause    the attribute's type is OdfDuration
     */ 
     public void setPause( OdfDuration pause )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "pause" ), pause.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:show-logo}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getShowLogo()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "show-logo" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:show-logo}.
     *
     *@param  isShowLogo    the attribute's type is OdfBoolean
     */ 
     public void setShowLogo( OdfBoolean isShowLogo )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "show-logo" ), isShowLogo.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:force-manual}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getForceManual()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "force-manual" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:force-manual}.
     *
     *@param  isForceManual    the attribute's type is OdfBoolean
     */ 
     public void setForceManual( OdfBoolean isForceManual )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "force-manual" ), isForceManual.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:mouse-visible}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getMouseVisible()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "mouse-visible" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:mouse-visible}.
     *
     *@param  isMouseVisible    the attribute's type is OdfBoolean
     */ 
     public void setMouseVisible( OdfBoolean isMouseVisible )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "mouse-visible" ), isMouseVisible.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:mouse-as-pen}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getMouseAsPen()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "mouse-as-pen" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:mouse-as-pen}.
     *
     *@param  isMouseAsPen    the attribute's type is OdfBoolean
     */ 
     public void setMouseAsPen( OdfBoolean isMouseAsPen )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "mouse-as-pen" ), isMouseAsPen.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:start-with-navigator}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getStartWithNavigator()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "start-with-navigator" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:start-with-navigator}.
     *
     *@param  isStartWithNavigator    the attribute's type is OdfBoolean
     */ 
     public void setStartWithNavigator( OdfBoolean isStartWithNavigator )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "start-with-navigator" ), isStartWithNavigator.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:animations}.
     *
     *@return return the attribute which type is OdfAnimationsType
     */
    public OdfAnimationsType getAnimations()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "animations" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "enabled";
        }

        return OdfAnimationsType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:animations}.
     *
     *@param  animations    the attribute's type is OdfAnimationsType
     */ 
     public void setAnimations( OdfAnimationsType animations )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "animations" ), animations.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:transition-on-click}.
     *
     *@return return the attribute which type is OdfTransitionOnClickType
     */
    public OdfTransitionOnClickType getTransitionOnClick()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "transition-on-click" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "enabled";
        }

        return OdfTransitionOnClickType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:transition-on-click}.
     *
     *@param  transitionOnClick    the attribute's type is OdfTransitionOnClickType
     */ 
     public void setTransitionOnClick( OdfTransitionOnClickType transitionOnClick )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "transition-on-click" ), transitionOnClick.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:stay-on-top}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getStayOnTop()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "stay-on-top" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:stay-on-top}.
     *
     *@param  isStayOnTop    the attribute's type is OdfBoolean
     */ 
     public void setStayOnTop( OdfBoolean isStayOnTop )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "stay-on-top" ), isStayOnTop.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:show-end-of-presentation-slide}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getShowEndOfPresentationSlide()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "show-end-of-presentation-slide" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:show-end-of-presentation-slide}.
     *
     *@param  isShowEndOfPresentationSlide    the attribute's type is OdfBoolean
     */ 
     public void setShowEndOfPresentationSlide( OdfBoolean isShowEndOfPresentationSlide )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "show-end-of-presentation-slide" ), isShowEndOfPresentationSlide.toString() );
    }

    /**
    * Create child element {@odfLink presentation:show}.
    *
    *@param name String   
    *@param pages String   
    *@return   return  the element {@odfLink presentation:show}
    */
    public OdfShowElement createShowElement(String   name, String   pages)
    {
        OdfShowElement  nShow = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfShowElement.class);
        nShow.setName( name);
        nShow.setPages( pages);
        this.appendChild( nShow);
        return  nShow;      
    }
    
}
