/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.presentation;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfPresentationClasses;
import org.odftoolkit.odfdom.dom.type.OdfLength;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink presentation:placeholder}.
 *
 */
public abstract class OdfPlaceholderElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.PRESENTATION, "placeholder" );

    /**
     * Create the instance of OdfPlaceholderElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfPlaceholderElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink presentation:placeholder}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfPlaceholderElement}
     *
     *@param object  The mandatory attribute {@attributeName  presentation:object}" 
     *@param x  The mandatory attribute {@attributeName  svg:x}" 
     *@param y  The mandatory attribute {@attributeName  svg:y}" 
     *@param width  The mandatory attribute {@attributeName  svg:width}" 
     *@param height  The mandatory attribute {@attributeName  svg:height}" 
     *
     */
    public void init(OdfPresentationClasses object, OdfLength x, OdfLength y, OdfLength width, OdfLength height)
    {
        setObject( object );
        setX( x );
        setY( y );
        setWidth( width );
        setHeight( height );
    }

    /**
     * Get value of attribute {@attributeName presentation:object}.
     *
     *@return return the attribute which type is OdfPresentationClasses
     */
    public OdfPresentationClasses getObject()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "object" ) );
        return OdfPresentationClasses.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:object}.
     *
     *@param  object    the attribute's type is OdfPresentationClasses
     */ 
     public void setObject( OdfPresentationClasses object )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "object" ), object.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:x}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x}.
     *
     *@param  x    the attribute's type is OdfLength
     */ 
     public void setX( OdfLength x )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ), x.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y}.
     *
     *@param  y    the attribute's type is OdfLength
     */ 
     public void setY( OdfLength y )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ), y.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:width}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:width}.
     *
     *@param  width    the attribute's type is OdfLength
     */ 
     public void setWidth( OdfLength width )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ), width.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:height}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:height}.
     *
     *@param  height    the attribute's type is OdfLength
     */ 
     public void setHeight( OdfLength height )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ), height.toString() );
    }

}
