/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.presentation;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.presentation.OdfActionType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfEffectType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfDirectionType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfSpeedType;
import org.odftoolkit.odfdom.dom.type.OdfPercent;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;

import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink presentation:event-listener}.
 *
 */
public abstract class OdfEventListenerElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.PRESENTATION, "event-listener" );

    /**
     * Create the instance of OdfEventListenerElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfEventListenerElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink presentation:event-listener}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfEventListenerElement}
     *
     *@param eventName  The mandatory attribute {@attributeName  script:event-name}" 
     *@param action  The mandatory attribute {@attributeName  presentation:action}" 
     *
     */
    public void init(String eventName, OdfActionType action)
    {
        setEventName( eventName );
        setAction( action );
    }

    /**
     * Get value of attribute {@attributeName script:event-name}.
     *
     *@return return the attribute which type is String
     */
    public String getEventName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SCRIPT, "event-name" ) );
    }

    /**
     * Set value of attribute {@attributeName script:event-name}.
     *
     *@param  eventName    the attribute's type is String
     */ 
     public void setEventName( String eventName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SCRIPT, "event-name" ), eventName );
    }

    /**
     * Get value of attribute {@attributeName presentation:action}.
     *
     *@return return the attribute which type is OdfActionType
     */
    public OdfActionType getAction()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "action" ) );
        return OdfActionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:action}.
     *
     *@param  action    the attribute's type is OdfActionType
     */ 
     public void setAction( OdfActionType action )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "action" ), action.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:effect}.
     *
     *@return return the attribute which type is OdfEffectType
     */
    public OdfEffectType getEffect()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "effect" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "none";
        }

        return OdfEffectType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:effect}.
     *
     *@param  effect    the attribute's type is OdfEffectType
     */ 
     public void setEffect( OdfEffectType effect )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "effect" ), effect.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:direction}.
     *
     *@return return the attribute which type is OdfDirectionType
     */
    public OdfDirectionType getDirection()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "direction" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "none";
        }

        return OdfDirectionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:direction}.
     *
     *@param  direction    the attribute's type is OdfDirectionType
     */ 
     public void setDirection( OdfDirectionType direction )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "direction" ), direction.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:speed}.
     *
     *@return return the attribute which type is OdfSpeedType
     */
    public OdfSpeedType getSpeed()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "speed" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "medium";
        }

        return OdfSpeedType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:speed}.
     *
     *@param  speed    the attribute's type is OdfSpeedType
     */ 
     public void setSpeed( OdfSpeedType speed )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "speed" ), speed.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:start-scale}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getStartScale()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "start-scale" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "100%";
        }

        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:start-scale}.
     *
     *@param  startScale    the attribute's type is OdfPercent
     */ 
     public void setStartScale( OdfPercent startScale )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "start-scale" ), startScale.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ), "embed" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "actuate" ), "onRequest" );
    }

    /**
     * Get value of attribute {@attributeName presentation:verb}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getVerb()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "verb" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:verb}.
     *
     *@param  verb    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setVerb( OdfNonNegativeInteger verb )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "verb" ), verb.toString() );
    }

    /**
    * Create child element {@odfLink presentation:sound}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink presentation:sound}
    */
    public OdfSoundElement createSoundElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfSoundElement  nSound = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSoundElement.class);
        nSound.setHref( href);
        this.appendChild( nSound);
        return  nSound;      
    }
    
}
