/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.presentation;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfId;

import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink presentation:dim}.
 *
 */
public abstract class OdfDimElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.PRESENTATION, "dim" );

    /**
     * Create the instance of OdfDimElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDimElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink presentation:dim}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDimElement}
     *
     *@param shapeId  The mandatory attribute {@attributeName  draw:shape-id}" 
     *@param color  The mandatory attribute {@attributeName  draw:color}" 
     *
     */
    public void init(OdfId shapeId, String color)
    {
        setShapeId( shapeId );
        setColor( color );
    }

    /**
     * Get value of attribute {@attributeName draw:shape-id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getShapeId()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "shape-id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:shape-id}.
     *
     *@param  shapeId    the attribute's type is OdfId
     */ 
     public void setShapeId( OdfId shapeId )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "shape-id" ), shapeId.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:color}.
     *
     *@return return the attribute which type is String
     */
    public String getColor()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "color" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:color}.
     *
     *@param  color    the attribute's type is String
     */ 
     public void setColor( String color )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "color" ), color );
    }

    /**
    * Create child element {@odfLink presentation:sound}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink presentation:sound}
    */
    public OdfSoundElement createSoundElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfSoundElement  nSound = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSoundElement.class);
        nSound.setHref( href);
        this.appendChild( nSound);
        return  nSound;      
    }
    
}
