/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.presentation;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.presentation.OdfSourceType;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink presentation:date-time-decl}.
 *
 */
public abstract class OdfDateTimeDeclElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.PRESENTATION, "date-time-decl" );

    /**
     * Create the instance of OdfDateTimeDeclElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDateTimeDeclElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink presentation:date-time-decl}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDateTimeDeclElement}
     *
     *@param name  The mandatory attribute {@attributeName  presentation:name}" 
     *@param source  The mandatory attribute {@attributeName  presentation:source}" 
     *
     */
    public void init(String name, OdfSourceType source)
    {
        setName( name );
        setSource( source );
    }

    /**
     * Get value of attribute {@attributeName presentation:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName presentation:source}.
     *
     *@return return the attribute which type is OdfSourceType
     */
    public OdfSourceType getSource()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "source" ) );
        return OdfSourceType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:source}.
     *
     *@param  source    the attribute's type is OdfSourceType
     */ 
     public void setSource( OdfSourceType source )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "source" ), source.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:data-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDataStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "data-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:data-style-name}.
     *
     *@param  dataStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDataStyleName( OdfStyleNameRef dataStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "data-style-name" ), dataStyleName.toString() );
    }

}
