/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.presentation;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink presentation:animation-group}.
 *
 */
public abstract class OdfAnimationGroupElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.PRESENTATION, "animation-group" );

    /**
     * Create the instance of OdfAnimationGroupElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfAnimationGroupElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink presentation:animation-group}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink presentation:show-shape}.
    *
    *@param shapeId  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@return   return  the element {@odfLink presentation:show-shape}
    */
    public OdfShowShapeElement createShowShapeElement(org.odftoolkit.odfdom.dom.type.OdfId   shapeId)
    {
        OdfShowShapeElement  nShowShape = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfShowShapeElement.class);
        nShowShape.setShapeId( shapeId);
        this.appendChild( nShowShape);
        return  nShowShape;      
    }
    
    /**
    * Create child element {@odfLink presentation:show-text}.
    *
    *@param shapeId  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@return   return  the element {@odfLink presentation:show-text}
    */
    public OdfShowTextElement createShowTextElement(org.odftoolkit.odfdom.dom.type.OdfId   shapeId)
    {
        OdfShowTextElement  nShowText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfShowTextElement.class);
        nShowText.setShapeId( shapeId);
        this.appendChild( nShowText);
        return  nShowText;      
    }
    
    /**
    * Create child element {@odfLink presentation:hide-shape}.
    *
    *@param shapeId  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@return   return  the element {@odfLink presentation:hide-shape}
    */
    public OdfHideShapeElement createHideShapeElement(org.odftoolkit.odfdom.dom.type.OdfId   shapeId)
    {
        OdfHideShapeElement  nHideShape = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHideShapeElement.class);
        nHideShape.setShapeId( shapeId);
        this.appendChild( nHideShape);
        return  nHideShape;      
    }
    
    /**
    * Create child element {@odfLink presentation:hide-text}.
    *
    *@param shapeId  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@return   return  the element {@odfLink presentation:hide-text}
    */
    public OdfHideTextElement createHideTextElement(org.odftoolkit.odfdom.dom.type.OdfId   shapeId)
    {
        OdfHideTextElement  nHideText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHideTextElement.class);
        nHideText.setShapeId( shapeId);
        this.appendChild( nHideText);
        return  nHideText;      
    }
    
    /**
    * Create child element {@odfLink presentation:dim}.
    *
    *@param shapeId  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@param color String   
    *@return   return  the element {@odfLink presentation:dim}
    */
    public OdfDimElement createDimElement(org.odftoolkit.odfdom.dom.type.OdfId   shapeId, String   color)
    {
        OdfDimElement  nDim = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDimElement.class);
        nDim.setShapeId( shapeId);
        nDim.setColor( color);
        this.appendChild( nDim);
        return  nDim;      
    }
    
    /**
    * Create child element {@odfLink presentation:play}.
    *
    *@param shapeId  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@return   return  the element {@odfLink presentation:play}
    */
    public OdfPlayElement createPlayElement(org.odftoolkit.odfdom.dom.type.OdfId   shapeId)
    {
        OdfPlayElement  nPlay = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPlayElement.class);
        nPlay.setShapeId( shapeId);
        this.appendChild( nPlay);
        return  nPlay;      
    }
    
}
