/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

import org.odftoolkit.odfdom.dom.element.form.OdfFormElement;
import org.odftoolkit.odfdom.dom.element.xforms.OdfModelElement;
import org.odftoolkit.odfdom.dom.element.text.OdfChangedRegionElement;
import org.odftoolkit.odfdom.dom.element.text.OdfVariableDeclElement;
import org.odftoolkit.odfdom.dom.type.office.OdfValueType;
import org.odftoolkit.odfdom.dom.element.text.OdfSequenceDeclElement;
import org.odftoolkit.odfdom.dom.element.text.OdfUserFieldDeclElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.element.text.OdfDdeConnectionDeclElement;
import org.odftoolkit.odfdom.dom.element.text.OdfAlphabeticalIndexAutoMarkFileElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.element.table.OdfCalculationSettingsElement;
import org.odftoolkit.odfdom.dom.element.table.OdfContentValidationsElement;
import org.odftoolkit.odfdom.dom.element.table.OdfLabelRangesElement;
import org.odftoolkit.odfdom.dom.element.text.OdfHeadingElement;
import org.odftoolkit.odfdom.dom.element.text.OdfParagraphElement;
import org.odftoolkit.odfdom.dom.element.text.OdfListElement;
import org.odftoolkit.odfdom.dom.element.text.OdfNumberedParagraphElement;
import org.odftoolkit.odfdom.dom.element.table.OdfTableElement;
import org.odftoolkit.odfdom.dom.element.text.OdfSectionElement;
import org.odftoolkit.odfdom.dom.type.text.OdfSectionDisplayType;
import org.odftoolkit.odfdom.dom.element.text.OdfSoftPageBreakElement;
import org.odftoolkit.odfdom.dom.element.text.OdfTableOfContentElement;
import org.odftoolkit.odfdom.dom.element.text.OdfIllustrationIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfTableIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfObjectIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfUserIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfAlphabeticalIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfBibliographyElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfRectElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfLineElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPolylineElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfRegularPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPathElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCircleElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfEllipseElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfGroupElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPageThumbnailElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCaptionElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfConnectorElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfControlElement;
import org.odftoolkit.odfdom.dom.element.dr3d.OdfSceneElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCustomShapeElement;
import org.odftoolkit.odfdom.dom.element.text.OdfPageSequenceElement;
import org.odftoolkit.odfdom.dom.element.table.OdfNamedExpressionsElement;
import org.odftoolkit.odfdom.dom.element.table.OdfDatabaseRangesElement;
import org.odftoolkit.odfdom.dom.element.table.OdfDataPilotTablesElement;
import org.odftoolkit.odfdom.dom.element.table.OdfConsolidationElement;
import org.odftoolkit.odfdom.dom.element.table.OdfDdeLinksElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:text}.
 *
 */
public abstract class OdfTextElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "text" );

    /**
     * Create the instance of OdfTextElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTextElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:text}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:global}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getGlobal()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "global" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:global}.
     *
     *@param  isGlobal    the attribute's type is OdfBoolean
     */ 
     public void setGlobal( OdfBoolean isGlobal )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "global" ), isGlobal.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-soft-page-breaks}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseSoftPageBreaks()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-soft-page-breaks" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-soft-page-breaks}.
     *
     *@param  isUseSoftPageBreaks    the attribute's type is OdfBoolean
     */ 
     public void setUseSoftPageBreaks( OdfBoolean isUseSoftPageBreaks )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-soft-page-breaks" ), isUseSoftPageBreaks.toString() );
    }

    /**
    * Create child element {@odfLink form:form}.
    *
    *@return   return  the element {@odfLink form:form}
    */
    public OdfFormElement createFormElement()
    {
        OdfFormElement  nForm = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFormElement.class);
        this.appendChild( nForm);
        return  nForm;
    }                   
               
    /**
    * Create child element {@odfLink xforms:model}.
    *
    *@return   return  the element {@odfLink xforms:model}
    */
    public OdfModelElement createModelElement()
    {
        OdfModelElement  nModel = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfModelElement.class);
        this.appendChild( nModel);
        return  nModel;
    }                   
               
    /**
    * Create child element {@odfLink text:changed-region}.
    *
    *@return   return  the element {@odfLink text:changed-region}
    */
    public OdfChangedRegionElement createChangedRegionElement()
    {
        OdfChangedRegionElement  nChangedRegion = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfChangedRegionElement.class);
        this.appendChild( nChangedRegion);
        return  nChangedRegion;
    }                   
               
    /**
    * Create child element {@odfLink text:variable-decl}.
    *
    *@param name String   
    *@param valueType     the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@return   return  the element {@odfLink text:variable-decl}
    */
    public OdfVariableDeclElement createVariableDeclElement(String   name, OdfValueType   valueType)
    {
        OdfVariableDeclElement  nVariableDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfVariableDeclElement.class);
        nVariableDecl.setName( name);
        nVariableDecl.setValueType( valueType);
        this.appendChild( nVariableDecl);
        return  nVariableDecl;      
    }
    
    /**
    * Create child element {@odfLink text:sequence-decl}.
    *
    *@param name String   
    *@param displayOutlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@return   return  the element {@odfLink text:sequence-decl}
    */
    public OdfSequenceDeclElement createSequenceDeclElement(String   name, org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   displayOutlineLevel)
    {
        OdfSequenceDeclElement  nSequenceDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSequenceDeclElement.class);
        nSequenceDecl.setName( name);
        nSequenceDecl.setDisplayOutlineLevel( displayOutlineLevel);
        this.appendChild( nSequenceDecl);
        return  nSequenceDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param value Double   
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, Double   value, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setValue( value);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param dateValue    the attribute's type is XMLGregorianCalendar
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfDate   dateValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setDateValue( dateValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param timeValue    the attribute's type is Duration
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfDuration   timeValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setTimeValue( timeValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param booleanValue  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfBoolean
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfBoolean   booleanValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setBooleanValue( booleanValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:dde-connection-decl}.
    *
    *@param name String   
    *@param ddeApplication String   
    *@param ddeTopic String   
    *@param ddeItem String   
    *@return   return  the element {@odfLink text:dde-connection-decl}
    */
    public OdfDdeConnectionDeclElement createDdeConnectionDeclElement(String   name, String   ddeApplication, String   ddeTopic, String   ddeItem)
    {
        OdfDdeConnectionDeclElement  nDdeConnectionDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDdeConnectionDeclElement.class);
        nDdeConnectionDecl.setName( name);
        nDdeConnectionDecl.setDdeApplication( ddeApplication);
        nDdeConnectionDecl.setDdeTopic( ddeTopic);
        nDdeConnectionDecl.setDdeItem( ddeItem);
        this.appendChild( nDdeConnectionDecl);
        return  nDdeConnectionDecl;      
    }
    
    /**
    * Create child element {@odfLink text:alphabetical-index-auto-mark-file}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink text:alphabetical-index-auto-mark-file}
    */
    public OdfAlphabeticalIndexAutoMarkFileElement createAlphabeticalIndexAutoMarkFileElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfAlphabeticalIndexAutoMarkFileElement  nAlphabeticalIndexAutoMarkFile = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAlphabeticalIndexAutoMarkFileElement.class);
        nAlphabeticalIndexAutoMarkFile.setHref( href);
        this.appendChild( nAlphabeticalIndexAutoMarkFile);
        return  nAlphabeticalIndexAutoMarkFile;      
    }
    
    /**
    * Create child element {@odfLink table:calculation-settings}.
    *
    *@return   return  the element {@odfLink table:calculation-settings}
    */
    public OdfCalculationSettingsElement createCalculationSettingsElement()
    {
        OdfCalculationSettingsElement  nCalculationSettings = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCalculationSettingsElement.class);
        this.appendChild( nCalculationSettings);
        return  nCalculationSettings;
    }                   
               
    /**
    * Create child element {@odfLink table:content-validations}.
    *
    *@return   return  the element {@odfLink table:content-validations}
    */
    public OdfContentValidationsElement createContentValidationsElement()
    {
        OdfContentValidationsElement  nContentValidations = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfContentValidationsElement.class);
        this.appendChild( nContentValidations);
        return  nContentValidations;
    }                   
               
    /**
    * Create child element {@odfLink table:label-ranges}.
    *
    *@return   return  the element {@odfLink table:label-ranges}
    */
    public OdfLabelRangesElement createLabelRangesElement()
    {
        OdfLabelRangesElement  nLabelRanges = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLabelRangesElement.class);
        this.appendChild( nLabelRanges);
        return  nLabelRanges;
    }                   
               
    /**
    * Create child element {@odfLink text:h}.
    *
    *@param outlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink text:h}
    */
    public OdfHeadingElement createHeadingElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   outlineLevel)
    {
        OdfHeadingElement  nHeading = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHeadingElement.class);
        nHeading.setOutlineLevel( outlineLevel);
        this.appendChild( nHeading);
        return  nHeading;      
    }
    
    /**
    * Create child element {@odfLink text:p}.
    *
    *@return   return  the element {@odfLink text:p}
    */
    public OdfParagraphElement createParagraphElement()
    {
        OdfParagraphElement  nParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParagraphElement.class);
        this.appendChild( nParagraph);
        return  nParagraph;
    }                   
               
    /**
    * Create child element {@odfLink text:list}.
    *
    *@return   return  the element {@odfLink text:list}
    */
    public OdfListElement createListElement()
    {
        OdfListElement  nList = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListElement.class);
        this.appendChild( nList);
        return  nList;
    }                   
               
    /**
    * Create child element {@odfLink text:numbered-paragraph}.
    *
    *@param listId String   
    *@return   return  the element {@odfLink text:numbered-paragraph}
    */
    public OdfNumberedParagraphElement createNumberedParagraphElement(String   listId)
    {
        OdfNumberedParagraphElement  nNumberedParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNumberedParagraphElement.class);
        nNumberedParagraph.setListId( listId);
        this.appendChild( nNumberedParagraph);
        return  nNumberedParagraph;      
    }
    
    /**
    * Create child element {@odfLink table:table}.
    *
    *@return   return  the element {@odfLink table:table}
    */
    public OdfTableElement createTableElement()
    {
        OdfTableElement  nTable = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableElement.class);
        this.appendChild( nTable);
        return  nTable;
    }                   
               
    /**
    * Create child element {@odfLink text:section}.
    *
    *@param name String   
    *@param display     the attribute's type is OdfSectionDisplayType, see {@attributeName  text:section-display} at specification
    *@return   return  the element {@odfLink text:section}
    */
    public OdfSectionElement createSectionElement(String   name, OdfSectionDisplayType   display)
    {
        OdfSectionElement  nSection = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSectionElement.class);
        nSection.setName( name);
        nSection.setDisplay( display);
        this.appendChild( nSection);
        return  nSection;      
    }
    
    /**
    * Create child element {@odfLink text:section}.
    *
    *@param display   the attribute's type is OdfSectionDisplayType, see {@attributeName  text:section-display} at specification
    *@param condition String   
    *@param name String   
    *@return   return  the element {@odfLink text:section}
    */
    public OdfSectionElement createSectionElement(OdfSectionDisplayType   display, String   condition, String   name)
    {
        OdfSectionElement  nSection = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSectionElement.class);
        nSection.setDisplay( display);
        nSection.setCondition( condition);
        nSection.setName( name);
        this.appendChild( nSection);
        return  nSection;      
    }
    
    /**
    * Create child element {@odfLink text:soft-page-break}.
    *
    *@return   return  the element {@odfLink text:soft-page-break}
    */
    public OdfSoftPageBreakElement createSoftPageBreakElement()
    {
        OdfSoftPageBreakElement  nSoftPageBreak = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSoftPageBreakElement.class);
        this.appendChild( nSoftPageBreak);
        return  nSoftPageBreak;
    }                   
               
    /**
    * Create child element {@odfLink text:table-of-content}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:table-of-content}
    */
    public OdfTableOfContentElement createTableOfContentElement(String   name)
    {
        OdfTableOfContentElement  nTableOfContent = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableOfContentElement.class);
        nTableOfContent.setName( name);
        this.appendChild( nTableOfContent);
        return  nTableOfContent;      
    }
    
    /**
    * Create child element {@odfLink text:illustration-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:illustration-index}
    */
    public OdfIllustrationIndexElement createIllustrationIndexElement(String   name)
    {
        OdfIllustrationIndexElement  nIllustrationIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIllustrationIndexElement.class);
        nIllustrationIndex.setName( name);
        this.appendChild( nIllustrationIndex);
        return  nIllustrationIndex;      
    }
    
    /**
    * Create child element {@odfLink text:table-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:table-index}
    */
    public OdfTableIndexElement createTableIndexElement(String   name)
    {
        OdfTableIndexElement  nTableIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableIndexElement.class);
        nTableIndex.setName( name);
        this.appendChild( nTableIndex);
        return  nTableIndex;      
    }
    
    /**
    * Create child element {@odfLink text:object-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:object-index}
    */
    public OdfObjectIndexElement createObjectIndexElement(String   name)
    {
        OdfObjectIndexElement  nObjectIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfObjectIndexElement.class);
        nObjectIndex.setName( name);
        this.appendChild( nObjectIndex);
        return  nObjectIndex;      
    }
    
    /**
    * Create child element {@odfLink text:user-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:user-index}
    */
    public OdfUserIndexElement createUserIndexElement(String   name)
    {
        OdfUserIndexElement  nUserIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserIndexElement.class);
        nUserIndex.setName( name);
        this.appendChild( nUserIndex);
        return  nUserIndex;      
    }
    
    /**
    * Create child element {@odfLink text:alphabetical-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:alphabetical-index}
    */
    public OdfAlphabeticalIndexElement createAlphabeticalIndexElement(String   name)
    {
        OdfAlphabeticalIndexElement  nAlphabeticalIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAlphabeticalIndexElement.class);
        nAlphabeticalIndex.setName( name);
        this.appendChild( nAlphabeticalIndex);
        return  nAlphabeticalIndex;      
    }
    
    /**
    * Create child element {@odfLink text:bibliography}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:bibliography}
    */
    public OdfBibliographyElement createBibliographyElement(String   name)
    {
        OdfBibliographyElement  nBibliography = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBibliographyElement.class);
        nBibliography.setName( name);
        this.appendChild( nBibliography);
        return  nBibliography;      
    }
    
    /**
    * Create child element {@odfLink draw:rect}.
    *
    *@return   return  the element {@odfLink draw:rect}
    */
    public OdfRectElement createRectElement()
    {
        OdfRectElement  nRect = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRectElement.class);
        this.appendChild( nRect);
        return  nRect;
    }                   
               
    /**
    * Create child element {@odfLink draw:line}.
    *
    *@param x1  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y1  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param x2  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y2  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink draw:line}
    */
    public OdfLineElement createLineElement(org.odftoolkit.odfdom.dom.type.OdfLength   x1, org.odftoolkit.odfdom.dom.type.OdfLength   y1, org.odftoolkit.odfdom.dom.type.OdfLength   x2, org.odftoolkit.odfdom.dom.type.OdfLength   y2)
    {
        OdfLineElement  nLine = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLineElement.class);
        nLine.setX1( x1);
        nLine.setY1( y1);
        nLine.setX2( x2);
        nLine.setY2( y2);
        this.appendChild( nLine);
        return  nLine;      
    }
    
    /**
    * Create child element {@odfLink draw:polyline}.
    *
    *@param points String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:polyline}
    */
    public OdfPolylineElement createPolylineElement(String   points, Integer   viewBox)
    {
        OdfPolylineElement  nPolyline = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPolylineElement.class);
        nPolyline.setPoints( points);
        nPolyline.setViewBox( viewBox);
        this.appendChild( nPolyline);
        return  nPolyline;      
    }
    
    /**
    * Create child element {@odfLink draw:polygon}.
    *
    *@param points String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:polygon}
    */
    public OdfPolygonElement createPolygonElement(String   points, Integer   viewBox)
    {
        OdfPolygonElement  nPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPolygonElement.class);
        nPolygon.setPoints( points);
        nPolygon.setViewBox( viewBox);
        this.appendChild( nPolygon);
        return  nPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:regular-polygon}.
    *
    *@param corners  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param concave   the attribute's type is Boolean
    *@return   return  the element {@odfLink draw:regular-polygon}
    */
    public OdfRegularPolygonElement createRegularPolygonElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   corners, org.odftoolkit.odfdom.dom.type.OdfBoolean   concave)
    {
        OdfRegularPolygonElement  nRegularPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegularPolygonElement.class);
        nRegularPolygon.setCorners( corners);
        nRegularPolygon.setConcave( concave);
        this.appendChild( nRegularPolygon);
        return  nRegularPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:regular-polygon}.
    *
    *@param concave   the attribute's type is Boolean
    *@param corners  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink draw:regular-polygon}
    */
    public OdfRegularPolygonElement createRegularPolygonElement(org.odftoolkit.odfdom.dom.type.OdfBoolean   concave, org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   corners)
    {
        OdfRegularPolygonElement  nRegularPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegularPolygonElement.class);
        nRegularPolygon.setConcave( concave);
        nRegularPolygon.setCorners( corners);
        this.appendChild( nRegularPolygon);
        return  nRegularPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:path}.
    *
    *@param d String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:path}
    */
    public OdfPathElement createPathElement(String   d, Integer   viewBox)
    {
        OdfPathElement  nPath = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPathElement.class);
        nPath.setD( d);
        nPath.setViewBox( viewBox);
        this.appendChild( nPath);
        return  nPath;      
    }
    
    /**
    * Create child element {@odfLink draw:circle}.
    *
    *@return   return  the element {@odfLink draw:circle}
    */
    public OdfCircleElement createCircleElement()
    {
        OdfCircleElement  nCircle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCircleElement.class);
        this.appendChild( nCircle);
        return  nCircle;
    }                   
               
    /**
    * Create child element {@odfLink draw:ellipse}.
    *
    *@return   return  the element {@odfLink draw:ellipse}
    */
    public OdfEllipseElement createEllipseElement()
    {
        OdfEllipseElement  nEllipse = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEllipseElement.class);
        this.appendChild( nEllipse);
        return  nEllipse;
    }                   
               
    /**
    * Create child element {@odfLink draw:g}.
    *
    *@return   return  the element {@odfLink draw:g}
    */
    public OdfGroupElement createGroupElement()
    {
        OdfGroupElement  nGroup = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGroupElement.class);
        this.appendChild( nGroup);
        return  nGroup;
    }                   
               
    /**
    * Create child element {@odfLink draw:page-thumbnail}.
    *
    *@return   return  the element {@odfLink draw:page-thumbnail}
    */
    public OdfPageThumbnailElement createPageThumbnailElement()
    {
        OdfPageThumbnailElement  nPageThumbnail = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageThumbnailElement.class);
        this.appendChild( nPageThumbnail);
        return  nPageThumbnail;
    }                   
               
    /**
    * Create child element {@odfLink draw:frame}.
    *
    *@return   return  the element {@odfLink draw:frame}
    */
    public OdfFrameElement createFrameElement()
    {
        OdfFrameElement  nFrame = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFrameElement.class);
        this.appendChild( nFrame);
        return  nFrame;
    }                   
               
    /**
    * Create child element {@odfLink draw:measure}.
    *
    *@param x1  the attribute's type is String
    *@param y1  the attribute's type is String
    *@param x2  the attribute's type is String
    *@param y2  the attribute's type is String
    *@return   return  the element {@odfLink draw:measure}
    */
    public org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement createdrawMeasureElement(org.odftoolkit.odfdom.dom.type.OdfLength   x1, org.odftoolkit.odfdom.dom.type.OdfLength   y1, org.odftoolkit.odfdom.dom.type.OdfLength   x2, org.odftoolkit.odfdom.dom.type.OdfLength   y2)
    {
        org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement  nMeasure = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement.class);
        nMeasure.setX1( x1);
        nMeasure.setY1( y1);
        nMeasure.setX2( x2);
        nMeasure.setY2( y2);
        this.appendChild( nMeasure);
        return  nMeasure;      
    }
    
    /**
    * Create child element {@odfLink draw:caption}.
    *
    *@return   return  the element {@odfLink draw:caption}
    */
    public OdfCaptionElement createCaptionElement()
    {
        OdfCaptionElement  nCaption = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCaptionElement.class);
        this.appendChild( nCaption);
        return  nCaption;
    }                   
               
    /**
    * Create child element {@odfLink draw:connector}.
    *
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:connector}
    */
    public OdfConnectorElement createConnectorElement(Integer   viewBox)
    {
        OdfConnectorElement  nConnector = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConnectorElement.class);
        nConnector.setViewBox( viewBox);
        this.appendChild( nConnector);
        return  nConnector;      
    }
    
    /**
    * Create child element {@odfLink draw:control}.
    *
    *@param control  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@return   return  the element {@odfLink draw:control}
    */
    public OdfControlElement createControlElement(org.odftoolkit.odfdom.dom.type.OdfId   control)
    {
        OdfControlElement  nControl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfControlElement.class);
        nControl.setControl( control);
        this.appendChild( nControl);
        return  nControl;      
    }
    
    /**
    * Create child element {@odfLink dr3d:scene}.
    *
    *@return   return  the element {@odfLink dr3d:scene}
    */
    public OdfSceneElement createSceneElement()
    {
        OdfSceneElement  nScene = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSceneElement.class);
        this.appendChild( nScene);
        return  nScene;
    }                   
               
    /**
    * Create child element {@odfLink draw:custom-shape}.
    *
    *@return   return  the element {@odfLink draw:custom-shape}
    */
    public OdfCustomShapeElement createCustomShapeElement()
    {
        OdfCustomShapeElement  nCustomShape = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCustomShapeElement.class);
        this.appendChild( nCustomShape);
        return  nCustomShape;
    }                   
               
    /**
    * Create child element {@odfLink draw:a}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink draw:a}
    */
    public org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement createdrawHyperlinkElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement  nHyperlink = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement.class);
        nHyperlink.setHref( href);
        this.appendChild( nHyperlink);
        return  nHyperlink;      
    }
    
    /**
    * Create child element {@odfLink text:page-sequence}.
    *
    *@return   return  the element {@odfLink text:page-sequence}
    */
    public OdfPageSequenceElement createPageSequenceElement()
    {
        OdfPageSequenceElement  nPageSequence = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageSequenceElement.class);
        this.appendChild( nPageSequence);
        return  nPageSequence;
    }                   
               
    /**
    * Create child element {@odfLink table:named-expressions}.
    *
    *@return   return  the element {@odfLink table:named-expressions}
    */
    public OdfNamedExpressionsElement createNamedExpressionsElement()
    {
        OdfNamedExpressionsElement  nNamedExpressions = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNamedExpressionsElement.class);
        this.appendChild( nNamedExpressions);
        return  nNamedExpressions;
    }                   
               
    /**
    * Create child element {@odfLink table:database-ranges}.
    *
    *@return   return  the element {@odfLink table:database-ranges}
    */
    public OdfDatabaseRangesElement createDatabaseRangesElement()
    {
        OdfDatabaseRangesElement  nDatabaseRanges = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseRangesElement.class);
        this.appendChild( nDatabaseRanges);
        return  nDatabaseRanges;
    }                   
               
    /**
    * Create child element {@odfLink table:data-pilot-tables}.
    *
    *@return   return  the element {@odfLink table:data-pilot-tables}
    */
    public OdfDataPilotTablesElement createDataPilotTablesElement()
    {
        OdfDataPilotTablesElement  nDataPilotTables = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotTablesElement.class);
        this.appendChild( nDataPilotTables);
        return  nDataPilotTables;
    }                   
               
    /**
    * Create child element {@odfLink table:consolidation}.
    *
    *@param function String   
    *@param sourceCellRangeAddresses  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList
    *@param targetCellAddress  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfCellAddress
    *@return   return  the element {@odfLink table:consolidation}
    */
    public OdfConsolidationElement createConsolidationElement(String   function, org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList   sourceCellRangeAddresses, org.odftoolkit.odfdom.dom.type.OdfCellAddress   targetCellAddress)
    {
        OdfConsolidationElement  nConsolidation = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConsolidationElement.class);
        nConsolidation.setFunction( function);
        nConsolidation.setSourceCellRangeAddresses( sourceCellRangeAddresses);
        nConsolidation.setTargetCellAddress( targetCellAddress);
        this.appendChild( nConsolidation);
        return  nConsolidation;      
    }
    
    /**
    * Create child element {@odfLink table:dde-links}.
    *
    *@return   return  the element {@odfLink table:dde-links}
    */
    public OdfDdeLinksElement createDdeLinksElement()
    {
        OdfDdeLinksElement  nDdeLinks = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDdeLinksElement.class);
        this.appendChild( nDdeLinks);
        return  nDdeLinks;
    }                   
               
}
