/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfContainerElementBase;

import org.odftoolkit.odfdom.dom.element.style.OdfStyleElement;
import org.odftoolkit.odfdom.dom.element.text.OdfListStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfNumberStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfCurrencyStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfPercentageStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfDateStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfTimeStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfBooleanStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfTextStyleElement;
import org.odftoolkit.odfdom.dom.element.style.OdfDefaultStyleElement;
import org.odftoolkit.odfdom.dom.element.style.OdfDefaultPageLayoutElement;
import org.odftoolkit.odfdom.dom.element.text.OdfOutlineStyleElement;
import org.odftoolkit.odfdom.dom.element.text.OdfNotesConfigurationElement;
import org.odftoolkit.odfdom.dom.type.text.OdfNoteClassType;
import org.odftoolkit.odfdom.dom.element.text.OdfBibliographyConfigurationElement;
import org.odftoolkit.odfdom.dom.element.text.OdfLinenumberingConfigurationElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfGradientElement;
import org.odftoolkit.odfdom.dom.type.draw.OdfGradientStyleType;
import org.odftoolkit.odfdom.dom.element.svg.OdfLinearGradientElement;
import org.odftoolkit.odfdom.dom.element.svg.OdfRadialGradientElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfHatchElement;
import org.odftoolkit.odfdom.dom.type.draw.OdfHatchStyleType;
import org.odftoolkit.odfdom.dom.element.draw.OdfFillImageElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.element.draw.OdfMarkerElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfStrokeDashElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfOpacityElement;
import org.odftoolkit.odfdom.dom.element.style.OdfPresentationPageLayoutElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:styles}.
 *
 */
public abstract class OdfStylesElement extends OdfContainerElementBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "styles" );

    /**
     * Create the instance of OdfStylesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfStylesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:styles}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink style:style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink style:style}
    */
    public OdfStyleElement createStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfStyleElement  nStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfStyleElement.class);
        nStyle.setName( name);
        this.appendChild( nStyle);
        return  nStyle;      
    }
    
    /**
    * Create child element {@odfLink text:list-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink text:list-style}
    */
    public OdfListStyleElement createListStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfListStyleElement  nListStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListStyleElement.class);
        nListStyle.setName( name);
        this.appendChild( nListStyle);
        return  nListStyle;      
    }
    
    /**
    * Create child element {@odfLink number:number-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:number-style}
    */
    public OdfNumberStyleElement createNumberStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfNumberStyleElement  nNumberStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNumberStyleElement.class);
        nNumberStyle.setName( name);
        this.appendChild( nNumberStyle);
        return  nNumberStyle;      
    }
    
    /**
    * Create child element {@odfLink number:currency-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:currency-style}
    */
    public OdfCurrencyStyleElement createCurrencyStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfCurrencyStyleElement  nCurrencyStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCurrencyStyleElement.class);
        nCurrencyStyle.setName( name);
        this.appendChild( nCurrencyStyle);
        return  nCurrencyStyle;      
    }
    
    /**
    * Create child element {@odfLink number:percentage-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:percentage-style}
    */
    public OdfPercentageStyleElement createPercentageStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfPercentageStyleElement  nPercentageStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPercentageStyleElement.class);
        nPercentageStyle.setName( name);
        this.appendChild( nPercentageStyle);
        return  nPercentageStyle;      
    }
    
    /**
    * Create child element {@odfLink number:date-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:date-style}
    */
    public OdfDateStyleElement createDateStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfDateStyleElement  nDateStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDateStyleElement.class);
        nDateStyle.setName( name);
        this.appendChild( nDateStyle);
        return  nDateStyle;      
    }
    
    /**
    * Create child element {@odfLink number:time-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:time-style}
    */
    public OdfTimeStyleElement createTimeStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfTimeStyleElement  nTimeStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTimeStyleElement.class);
        nTimeStyle.setName( name);
        this.appendChild( nTimeStyle);
        return  nTimeStyle;      
    }
    
    /**
    * Create child element {@odfLink number:boolean-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:boolean-style}
    */
    public OdfBooleanStyleElement createBooleanStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfBooleanStyleElement  nBooleanStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBooleanStyleElement.class);
        nBooleanStyle.setName( name);
        this.appendChild( nBooleanStyle);
        return  nBooleanStyle;      
    }
    
    /**
    * Create child element {@odfLink number:text-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:text-style}
    */
    public OdfTextStyleElement createTextStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfTextStyleElement  nTextStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextStyleElement.class);
        nTextStyle.setName( name);
        this.appendChild( nTextStyle);
        return  nTextStyle;      
    }
    
    /**
    * Create child element {@odfLink style:default-style}.
    *
    *@return   return  the element {@odfLink style:default-style}
    */
    public OdfDefaultStyleElement createDefaultStyleElement()
    {
        OdfDefaultStyleElement  nDefaultStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDefaultStyleElement.class);
        this.appendChild( nDefaultStyle);
        return  nDefaultStyle;
    }                   
               
    /**
    * Create child element {@odfLink style:default-page-layout}.
    *
    *@return   return  the element {@odfLink style:default-page-layout}
    */
    public OdfDefaultPageLayoutElement createDefaultPageLayoutElement()
    {
        OdfDefaultPageLayoutElement  nDefaultPageLayout = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDefaultPageLayoutElement.class);
        this.appendChild( nDefaultPageLayout);
        return  nDefaultPageLayout;
    }                   
               
    /**
    * Create child element {@odfLink text:outline-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink text:outline-style}
    */
    public OdfOutlineStyleElement createOutlineStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfOutlineStyleElement  nOutlineStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfOutlineStyleElement.class);
        nOutlineStyle.setName( name);
        this.appendChild( nOutlineStyle);
        return  nOutlineStyle;      
    }
    
    /**
    * Create child element {@odfLink text:notes-configuration}.
    *
    *@param noteClass     the attribute's type is OdfNoteClassType, see {@attributeName  text:note-class} at specification
    *@return   return  the element {@odfLink text:notes-configuration}
    */
    public OdfNotesConfigurationElement createNotesConfigurationElement(OdfNoteClassType   noteClass)
    {
        OdfNotesConfigurationElement  nNotesConfiguration = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNotesConfigurationElement.class);
        nNotesConfiguration.setNoteClass( noteClass);
        this.appendChild( nNotesConfiguration);
        return  nNotesConfiguration;      
    }
    
    /**
    * Create child element {@odfLink text:bibliography-configuration}.
    *
    *@return   return  the element {@odfLink text:bibliography-configuration}
    */
    public OdfBibliographyConfigurationElement createBibliographyConfigurationElement()
    {
        OdfBibliographyConfigurationElement  nBibliographyConfiguration = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBibliographyConfigurationElement.class);
        this.appendChild( nBibliographyConfiguration);
        return  nBibliographyConfiguration;
    }                   
               
    /**
    * Create child element {@odfLink text:linenumbering-configuration}.
    *
    *@return   return  the element {@odfLink text:linenumbering-configuration}
    */
    public OdfLinenumberingConfigurationElement createLinenumberingConfigurationElement()
    {
        OdfLinenumberingConfigurationElement  nLinenumberingConfiguration = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLinenumberingConfigurationElement.class);
        this.appendChild( nLinenumberingConfiguration);
        return  nLinenumberingConfiguration;
    }                   
               
    /**
    * Create child element {@odfLink draw:gradient}.
    *
    *@param style     the attribute's type is OdfGradientStyleType, see {@attributeName  draw:gradient-style} at specification
    *@return   return  the element {@odfLink draw:gradient}
    */
    public OdfGradientElement createGradientElement(OdfGradientStyleType   style)
    {
        OdfGradientElement  nGradient = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGradientElement.class);
        nGradient.setStyle( style);
        this.appendChild( nGradient);
        return  nGradient;      
    }
    
    /**
    * Create child element {@odfLink svg:linearGradient}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink svg:linearGradient}
    */
    public OdfLinearGradientElement createLinearGradientElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfLinearGradientElement  nLinearGradient = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLinearGradientElement.class);
        nLinearGradient.setName( name);
        this.appendChild( nLinearGradient);
        return  nLinearGradient;      
    }
    
    /**
    * Create child element {@odfLink svg:radialGradient}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink svg:radialGradient}
    */
    public OdfRadialGradientElement createRadialGradientElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfRadialGradientElement  nRadialGradient = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRadialGradientElement.class);
        nRadialGradient.setName( name);
        this.appendChild( nRadialGradient);
        return  nRadialGradient;      
    }
    
    /**
    * Create child element {@odfLink draw:hatch}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@param style     the attribute's type is OdfHatchStyleType, see {@attributeName  draw:hatch-style} at specification
    *@return   return  the element {@odfLink draw:hatch}
    */
    public OdfHatchElement createHatchElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name, OdfHatchStyleType   style)
    {
        OdfHatchElement  nHatch = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHatchElement.class);
        nHatch.setName( name);
        nHatch.setStyle( style);
        this.appendChild( nHatch);
        return  nHatch;      
    }
    
    /**
    * Create child element {@odfLink draw:fill-image}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink draw:fill-image}
    */
    public OdfFillImageElement createFillImageElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name, org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfFillImageElement  nFillImage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFillImageElement.class);
        nFillImage.setName( name);
        nFillImage.setHref( href);
        this.appendChild( nFillImage);
        return  nFillImage;      
    }
    
    /**
    * Create child element {@odfLink draw:marker}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@param viewBox Integer   
    *@param d String   
    *@return   return  the element {@odfLink draw:marker}
    */
    public OdfMarkerElement createMarkerElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name, Integer   viewBox, String   d)
    {
        OdfMarkerElement  nMarker = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMarkerElement.class);
        nMarker.setName( name);
        nMarker.setViewBox( viewBox);
        nMarker.setD( d);
        this.appendChild( nMarker);
        return  nMarker;      
    }
    
    /**
    * Create child element {@odfLink draw:stroke-dash}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink draw:stroke-dash}
    */
    public OdfStrokeDashElement createStrokeDashElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfStrokeDashElement  nStrokeDash = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfStrokeDashElement.class);
        nStrokeDash.setName( name);
        this.appendChild( nStrokeDash);
        return  nStrokeDash;      
    }
    
    /**
    * Create child element {@odfLink draw:opacity}.
    *
    *@param style     the attribute's type is OdfGradientStyleType, see {@attributeName  draw:gradient-style} at specification
    *@return   return  the element {@odfLink draw:opacity}
    */
    public OdfOpacityElement createOpacityElement(OdfGradientStyleType   style)
    {
        OdfOpacityElement  nOpacity = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfOpacityElement.class);
        nOpacity.setStyle( style);
        this.appendChild( nOpacity);
        return  nOpacity;      
    }
    
    /**
    * Create child element {@odfLink style:presentation-page-layout}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink style:presentation-page-layout}
    */
    public OdfPresentationPageLayoutElement createPresentationPageLayoutElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfPresentationPageLayoutElement  nPresentationPageLayout = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPresentationPageLayoutElement.class);
        nPresentationPageLayout.setName( name);
        this.appendChild( nPresentationPageLayout);
        return  nPresentationPageLayout;      
    }
    
}
