/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import org.odftoolkit.odfdom.dom.element.meta.OdfGeneratorElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfTitleElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfDescriptionElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfSubjectElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfKeywordElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfInitialCreatorElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfCreatorElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfPrintedByElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfCreationDateElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfDateElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfPrintDateElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfTemplateElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.element.meta.OdfAutoReloadElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfHyperlinkBehaviourElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfLanguageElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfEditingCyclesElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfEditingDurationElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfDocumentStatisticElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfUserDefinedElement;
import org.odftoolkit.odfdom.dom.type.meta.OdfValueType;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:meta}.
 *
 */
public abstract class OdfMetaElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "meta" );

    /**
     * Create the instance of OdfMetaElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfMetaElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:meta}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink meta:generator}.
    *
    *@return   return  the element {@odfLink meta:generator}
    */
    public OdfGeneratorElement createGeneratorElement()
    {
        OdfGeneratorElement  nGenerator = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGeneratorElement.class);
        this.appendChild( nGenerator);
        return  nGenerator;
    }                   
               
    /**
    * Create child element {@odfLink dc:title}.
    *
    *@return   return  the element {@odfLink dc:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink dc:description}.
    *
    *@return   return  the element {@odfLink dc:description}
    */
    public OdfDescriptionElement createDescriptionElement()
    {
        OdfDescriptionElement  nDescription = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescriptionElement.class);
        this.appendChild( nDescription);
        return  nDescription;
    }                   
               
    /**
    * Create child element {@odfLink dc:subject}.
    *
    *@return   return  the element {@odfLink dc:subject}
    */
    public OdfSubjectElement createSubjectElement()
    {
        OdfSubjectElement  nSubject = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSubjectElement.class);
        this.appendChild( nSubject);
        return  nSubject;
    }                   
               
    /**
    * Create child element {@odfLink meta:keyword}.
    *
    *@return   return  the element {@odfLink meta:keyword}
    */
    public OdfKeywordElement createKeywordElement()
    {
        OdfKeywordElement  nKeyword = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfKeywordElement.class);
        this.appendChild( nKeyword);
        return  nKeyword;
    }                   
               
    /**
    * Create child element {@odfLink meta:initial-creator}.
    *
    *@return   return  the element {@odfLink meta:initial-creator}
    */
    public OdfInitialCreatorElement createInitialCreatorElement()
    {
        OdfInitialCreatorElement  nInitialCreator = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfInitialCreatorElement.class);
        this.appendChild( nInitialCreator);
        return  nInitialCreator;
    }                   
               
    /**
    * Create child element {@odfLink dc:creator}.
    *
    *@return   return  the element {@odfLink dc:creator}
    */
    public OdfCreatorElement createCreatorElement()
    {
        OdfCreatorElement  nCreator = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCreatorElement.class);
        this.appendChild( nCreator);
        return  nCreator;
    }                   
               
    /**
    * Create child element {@odfLink meta:printed-by}.
    *
    *@return   return  the element {@odfLink meta:printed-by}
    */
    public OdfPrintedByElement createPrintedByElement()
    {
        OdfPrintedByElement  nPrintedBy = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPrintedByElement.class);
        this.appendChild( nPrintedBy);
        return  nPrintedBy;
    }                   
               
    /**
    * Create child element {@odfLink meta:creation-date}.
    *
    *@return   return  the element {@odfLink meta:creation-date}
    */
    public OdfCreationDateElement createCreationDateElement()
    {
        OdfCreationDateElement  nCreationDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCreationDateElement.class);
        this.appendChild( nCreationDate);
        return  nCreationDate;
    }                   
               
    /**
    * Create child element {@odfLink dc:date}.
    *
    *@return   return  the element {@odfLink dc:date}
    */
    public OdfDateElement createDateElement()
    {
        OdfDateElement  nDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDateElement.class);
        this.appendChild( nDate);
        return  nDate;
    }                   
               
    /**
    * Create child element {@odfLink meta:print-date}.
    *
    *@return   return  the element {@odfLink meta:print-date}
    */
    public OdfPrintDateElement createPrintDateElement()
    {
        OdfPrintDateElement  nPrintDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPrintDateElement.class);
        this.appendChild( nPrintDate);
        return  nPrintDate;
    }                   
               
    /**
    * Create child element {@odfLink meta:template}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink meta:template}
    */
    public OdfTemplateElement createTemplateElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfTemplateElement  nTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTemplateElement.class);
        nTemplate.setHref( href);
        this.appendChild( nTemplate);
        return  nTemplate;      
    }
    
    /**
    * Create child element {@odfLink meta:auto-reload}.
    *
    *@return   return  the element {@odfLink meta:auto-reload}
    */
    public OdfAutoReloadElement createAutoReloadElement()
    {
        OdfAutoReloadElement  nAutoReload = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAutoReloadElement.class);
        this.appendChild( nAutoReload);
        return  nAutoReload;
    }                   
               
    /**
    * Create child element {@odfLink meta:hyperlink-behaviour}.
    *
    *@return   return  the element {@odfLink meta:hyperlink-behaviour}
    */
    public OdfHyperlinkBehaviourElement createHyperlinkBehaviourElement()
    {
        OdfHyperlinkBehaviourElement  nHyperlinkBehaviour = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHyperlinkBehaviourElement.class);
        this.appendChild( nHyperlinkBehaviour);
        return  nHyperlinkBehaviour;
    }                   
               
    /**
    * Create child element {@odfLink dc:language}.
    *
    *@return   return  the element {@odfLink dc:language}
    */
    public OdfLanguageElement createLanguageElement()
    {
        OdfLanguageElement  nLanguage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLanguageElement.class);
        this.appendChild( nLanguage);
        return  nLanguage;
    }                   
               
    /**
    * Create child element {@odfLink meta:editing-cycles}.
    *
    *@return   return  the element {@odfLink meta:editing-cycles}
    */
    public OdfEditingCyclesElement createEditingCyclesElement()
    {
        OdfEditingCyclesElement  nEditingCycles = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEditingCyclesElement.class);
        this.appendChild( nEditingCycles);
        return  nEditingCycles;
    }                   
               
    /**
    * Create child element {@odfLink meta:editing-duration}.
    *
    *@return   return  the element {@odfLink meta:editing-duration}
    */
    public OdfEditingDurationElement createEditingDurationElement()
    {
        OdfEditingDurationElement  nEditingDuration = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEditingDurationElement.class);
        this.appendChild( nEditingDuration);
        return  nEditingDuration;
    }                   
               
    /**
    * Create child element {@odfLink meta:document-statistic}.
    *
    *@return   return  the element {@odfLink meta:document-statistic}
    */
    public OdfDocumentStatisticElement createDocumentStatisticElement()
    {
        OdfDocumentStatisticElement  nDocumentStatistic = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDocumentStatisticElement.class);
        this.appendChild( nDocumentStatistic);
        return  nDocumentStatistic;
    }                   
               
    /**
    * Create child element {@odfLink meta:user-defined}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  meta:value-type} at specification
    *@param name String   
    *@return   return  the element {@odfLink meta:user-defined}
    */
    public OdfUserDefinedElement createUserDefinedElement(OdfValueType   valueType, String   name)
    {
        OdfUserDefinedElement  nUserDefined = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserDefinedElement.class);
        nUserDefined.setValueType( valueType);
        nUserDefined.setName( name);
        this.appendChild( nUserDefined);
        return  nUserDefined;      
    }
    
}
