/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfContainerElementBase;

import org.odftoolkit.odfdom.dom.element.style.OdfMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.OdfHandoutMasterElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfLayerSetElement;
import org.odftoolkit.odfdom.dom.element.table.OdfTableTemplateElement;
import org.odftoolkit.odfdom.dom.type.table.OdfRowOrColumnType;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:master-styles}.
 *
 */
public abstract class OdfMasterStylesElement extends OdfContainerElementBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "master-styles" );

    /**
     * Create the instance of OdfMasterStylesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfMasterStylesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:master-styles}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink style:master-page}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@param pageLayoutName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink style:master-page}
    */
    public OdfMasterPageElement createMasterPageElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name, org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   pageLayoutName)
    {
        OdfMasterPageElement  nMasterPage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMasterPageElement.class);
        nMasterPage.setName( name);
        nMasterPage.setPageLayoutName( pageLayoutName);
        this.appendChild( nMasterPage);
        return  nMasterPage;      
    }
    
    /**
    * Create child element {@odfLink style:handout-master}.
    *
    *@param pageLayoutName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink style:handout-master}
    */
    public OdfHandoutMasterElement createHandoutMasterElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   pageLayoutName)
    {
        OdfHandoutMasterElement  nHandoutMaster = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHandoutMasterElement.class);
        nHandoutMaster.setPageLayoutName( pageLayoutName);
        this.appendChild( nHandoutMaster);
        return  nHandoutMaster;      
    }
    
    /**
    * Create child element {@odfLink draw:layer-set}.
    *
    *@return   return  the element {@odfLink draw:layer-set}
    */
    public OdfLayerSetElement createLayerSetElement()
    {
        OdfLayerSetElement  nLayerSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLayerSetElement.class);
        this.appendChild( nLayerSet);
        return  nLayerSet;
    }                   
               
    /**
    * Create child element {@odfLink table:table-template}.
    *
    *@param name String   
    *@param firstRowStartColumn     the attribute's type is OdfRowOrColumnType, see {@attributeName  table:row-or-column} at specification
    *@param firstRowEndColumn     the attribute's type is OdfRowOrColumnType, see {@attributeName  table:row-or-column} at specification
    *@param lastRowStartColumn     the attribute's type is OdfRowOrColumnType, see {@attributeName  table:row-or-column} at specification
    *@param lastRowEndColumn     the attribute's type is OdfRowOrColumnType, see {@attributeName  table:row-or-column} at specification
    *@return   return  the element {@odfLink table:table-template}
    */
    public OdfTableTemplateElement createTableTemplateElement(String   name, OdfRowOrColumnType   firstRowStartColumn, OdfRowOrColumnType   firstRowEndColumn, OdfRowOrColumnType   lastRowStartColumn, OdfRowOrColumnType   lastRowEndColumn)
    {
        OdfTableTemplateElement  nTableTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableTemplateElement.class);
        nTableTemplate.setName( name);
        nTableTemplate.setFirstRowStartColumn( firstRowStartColumn);
        nTableTemplate.setFirstRowEndColumn( firstRowEndColumn);
        nTableTemplate.setLastRowStartColumn( lastRowStartColumn);
        nTableTemplate.setLastRowEndColumn( lastRowEndColumn);
        this.appendChild( nTableTemplate);
        return  nTableTemplate;      
    }
    
}
