/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

import org.odftoolkit.odfdom.dom.element.form.OdfFormElement;
import org.odftoolkit.odfdom.dom.element.xforms.OdfModelElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:forms}.
 *
 */
public abstract class OdfFormsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "forms" );

    /**
     * Create the instance of OdfFormsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfFormsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:forms}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName form:automatic-focus}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAutomaticFocus()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "automatic-focus" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:automatic-focus}.
     *
     *@param  isAutomaticFocus    the attribute's type is OdfBoolean
     */ 
     public void setAutomaticFocus( OdfBoolean isAutomaticFocus )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "automatic-focus" ), isAutomaticFocus.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:apply-design-mode}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getApplyDesignMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "apply-design-mode" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:apply-design-mode}.
     *
     *@param  isApplyDesignMode    the attribute's type is OdfBoolean
     */ 
     public void setApplyDesignMode( OdfBoolean isApplyDesignMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "apply-design-mode" ), isApplyDesignMode.toString() );
    }

    /**
    * Create child element {@odfLink form:form}.
    *
    *@return   return  the element {@odfLink form:form}
    */
    public OdfFormElement createFormElement()
    {
        OdfFormElement  nForm = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFormElement.class);
        this.appendChild( nForm);
        return  nForm;
    }                   
               
    /**
    * Create child element {@odfLink xforms:model}.
    *
    *@return   return  the element {@odfLink xforms:model}
    */
    public OdfModelElement createModelElement()
    {
        OdfModelElement  nModel = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfModelElement.class);
        this.appendChild( nModel);
        return  nModel;
    }                   
               
}
