/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import org.odftoolkit.odfdom.dom.element.script.OdfEventListenerElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.presentation.OdfActionType;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:event-listeners}.
 *
 */
public abstract class OdfEventListenersElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "event-listeners" );

    /**
     * Create the instance of OdfEventListenersElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfEventListenersElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:event-listeners}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink script:event-listener}.
    *
    *@param eventName String   
    *@param language String   
    *@param macroName String   
    *@return   return  the element {@odfLink script:event-listener}
    */
    public OdfEventListenerElement createEventListenerElement(String   eventName, String   language, String   macroName)
    {
        OdfEventListenerElement  nEventListener = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenerElement.class);
        nEventListener.setEventName( eventName);
        nEventListener.setLanguage( language);
        nEventListener.setMacroName( macroName);
        this.appendChild( nEventListener);
        return  nEventListener;      
    }
    
    /**
    * Create child element {@odfLink script:event-listener}.
    *
    *@param href    the attribute's type is URI
    *@param eventName String   
    *@param language String   
    *@return   return  the element {@odfLink script:event-listener}
    */
    public OdfEventListenerElement createEventListenerElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href, String   eventName, String   language)
    {
        OdfEventListenerElement  nEventListener = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenerElement.class);
        nEventListener.setHref( href);
        nEventListener.setEventName( eventName);
        nEventListener.setLanguage( language);
        this.appendChild( nEventListener);
        return  nEventListener;      
    }
    
    /**
    * Create child element {@odfLink presentation:event-listener}.
    *
    *@param eventName String   
    *@param action     the attribute's type is OdfActionType, see {@attributeName  presentation:action} at specification
    *@return   return  the element {@odfLink presentation:event-listener}
    */
    public org.odftoolkit.odfdom.dom.element.presentation.OdfEventListenerElement createpresentationEventListenerElement(String   eventName, OdfActionType   action)
    {
        org.odftoolkit.odfdom.dom.element.presentation.OdfEventListenerElement  nEventListener = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.presentation.OdfEventListenerElement.class);
        nEventListener.setEventName( eventName);
        nEventListener.setAction( action);
        this.appendChild( nEventListener);
        return  nEventListener;      
    }
    
}
