/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import org.odftoolkit.odfdom.dom.element.text.OdfVariableDeclElement;
import org.odftoolkit.odfdom.dom.type.office.OdfValueType;
import org.odftoolkit.odfdom.dom.element.text.OdfSequenceDeclElement;
import org.odftoolkit.odfdom.dom.element.text.OdfUserFieldDeclElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.element.text.OdfDdeConnectionDeclElement;
import org.odftoolkit.odfdom.dom.element.text.OdfAlphabeticalIndexAutoMarkFileElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.element.table.OdfCalculationSettingsElement;
import org.odftoolkit.odfdom.dom.element.table.OdfContentValidationsElement;
import org.odftoolkit.odfdom.dom.element.table.OdfLabelRangesElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPageElement;
import org.odftoolkit.odfdom.dom.element.table.OdfNamedExpressionsElement;
import org.odftoolkit.odfdom.dom.element.table.OdfDatabaseRangesElement;
import org.odftoolkit.odfdom.dom.element.table.OdfDataPilotTablesElement;
import org.odftoolkit.odfdom.dom.element.table.OdfConsolidationElement;
import org.odftoolkit.odfdom.dom.element.table.OdfDdeLinksElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:drawing}.
 *
 */
public abstract class OdfDrawingElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "drawing" );

    /**
     * Create the instance of OdfDrawingElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDrawingElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:drawing}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink text:variable-decl}.
    *
    *@param name String   
    *@param valueType     the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@return   return  the element {@odfLink text:variable-decl}
    */
    public OdfVariableDeclElement createVariableDeclElement(String   name, OdfValueType   valueType)
    {
        OdfVariableDeclElement  nVariableDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfVariableDeclElement.class);
        nVariableDecl.setName( name);
        nVariableDecl.setValueType( valueType);
        this.appendChild( nVariableDecl);
        return  nVariableDecl;      
    }
    
    /**
    * Create child element {@odfLink text:sequence-decl}.
    *
    *@param name String   
    *@param displayOutlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@return   return  the element {@odfLink text:sequence-decl}
    */
    public OdfSequenceDeclElement createSequenceDeclElement(String   name, org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   displayOutlineLevel)
    {
        OdfSequenceDeclElement  nSequenceDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSequenceDeclElement.class);
        nSequenceDecl.setName( name);
        nSequenceDecl.setDisplayOutlineLevel( displayOutlineLevel);
        this.appendChild( nSequenceDecl);
        return  nSequenceDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param value Double   
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, Double   value, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setValue( value);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param dateValue    the attribute's type is XMLGregorianCalendar
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfDate   dateValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setDateValue( dateValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param timeValue    the attribute's type is Duration
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfDuration   timeValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setTimeValue( timeValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param booleanValue  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfBoolean
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfBoolean   booleanValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setBooleanValue( booleanValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:dde-connection-decl}.
    *
    *@param name String   
    *@param ddeApplication String   
    *@param ddeTopic String   
    *@param ddeItem String   
    *@return   return  the element {@odfLink text:dde-connection-decl}
    */
    public OdfDdeConnectionDeclElement createDdeConnectionDeclElement(String   name, String   ddeApplication, String   ddeTopic, String   ddeItem)
    {
        OdfDdeConnectionDeclElement  nDdeConnectionDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDdeConnectionDeclElement.class);
        nDdeConnectionDecl.setName( name);
        nDdeConnectionDecl.setDdeApplication( ddeApplication);
        nDdeConnectionDecl.setDdeTopic( ddeTopic);
        nDdeConnectionDecl.setDdeItem( ddeItem);
        this.appendChild( nDdeConnectionDecl);
        return  nDdeConnectionDecl;      
    }
    
    /**
    * Create child element {@odfLink text:alphabetical-index-auto-mark-file}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink text:alphabetical-index-auto-mark-file}
    */
    public OdfAlphabeticalIndexAutoMarkFileElement createAlphabeticalIndexAutoMarkFileElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfAlphabeticalIndexAutoMarkFileElement  nAlphabeticalIndexAutoMarkFile = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAlphabeticalIndexAutoMarkFileElement.class);
        nAlphabeticalIndexAutoMarkFile.setHref( href);
        this.appendChild( nAlphabeticalIndexAutoMarkFile);
        return  nAlphabeticalIndexAutoMarkFile;      
    }
    
    /**
    * Create child element {@odfLink table:calculation-settings}.
    *
    *@return   return  the element {@odfLink table:calculation-settings}
    */
    public OdfCalculationSettingsElement createCalculationSettingsElement()
    {
        OdfCalculationSettingsElement  nCalculationSettings = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCalculationSettingsElement.class);
        this.appendChild( nCalculationSettings);
        return  nCalculationSettings;
    }                   
               
    /**
    * Create child element {@odfLink table:content-validations}.
    *
    *@return   return  the element {@odfLink table:content-validations}
    */
    public OdfContentValidationsElement createContentValidationsElement()
    {
        OdfContentValidationsElement  nContentValidations = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfContentValidationsElement.class);
        this.appendChild( nContentValidations);
        return  nContentValidations;
    }                   
               
    /**
    * Create child element {@odfLink table:label-ranges}.
    *
    *@return   return  the element {@odfLink table:label-ranges}
    */
    public OdfLabelRangesElement createLabelRangesElement()
    {
        OdfLabelRangesElement  nLabelRanges = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLabelRangesElement.class);
        this.appendChild( nLabelRanges);
        return  nLabelRanges;
    }                   
               
    /**
    * Create child element {@odfLink draw:page}.
    *
    *@param masterPageName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink draw:page}
    */
    public OdfPageElement createPageElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   masterPageName)
    {
        OdfPageElement  nPage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageElement.class);
        nPage.setMasterPageName( masterPageName);
        this.appendChild( nPage);
        return  nPage;      
    }
    
    /**
    * Create child element {@odfLink table:named-expressions}.
    *
    *@return   return  the element {@odfLink table:named-expressions}
    */
    public OdfNamedExpressionsElement createNamedExpressionsElement()
    {
        OdfNamedExpressionsElement  nNamedExpressions = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNamedExpressionsElement.class);
        this.appendChild( nNamedExpressions);
        return  nNamedExpressions;
    }                   
               
    /**
    * Create child element {@odfLink table:database-ranges}.
    *
    *@return   return  the element {@odfLink table:database-ranges}
    */
    public OdfDatabaseRangesElement createDatabaseRangesElement()
    {
        OdfDatabaseRangesElement  nDatabaseRanges = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseRangesElement.class);
        this.appendChild( nDatabaseRanges);
        return  nDatabaseRanges;
    }                   
               
    /**
    * Create child element {@odfLink table:data-pilot-tables}.
    *
    *@return   return  the element {@odfLink table:data-pilot-tables}
    */
    public OdfDataPilotTablesElement createDataPilotTablesElement()
    {
        OdfDataPilotTablesElement  nDataPilotTables = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotTablesElement.class);
        this.appendChild( nDataPilotTables);
        return  nDataPilotTables;
    }                   
               
    /**
    * Create child element {@odfLink table:consolidation}.
    *
    *@param function String   
    *@param sourceCellRangeAddresses  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList
    *@param targetCellAddress  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfCellAddress
    *@return   return  the element {@odfLink table:consolidation}
    */
    public OdfConsolidationElement createConsolidationElement(String   function, org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList   sourceCellRangeAddresses, org.odftoolkit.odfdom.dom.type.OdfCellAddress   targetCellAddress)
    {
        OdfConsolidationElement  nConsolidation = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConsolidationElement.class);
        nConsolidation.setFunction( function);
        nConsolidation.setSourceCellRangeAddresses( sourceCellRangeAddresses);
        nConsolidation.setTargetCellAddress( targetCellAddress);
        this.appendChild( nConsolidation);
        return  nConsolidation;      
    }
    
    /**
    * Create child element {@odfLink table:dde-links}.
    *
    *@return   return  the element {@odfLink table:dde-links}
    */
    public OdfDdeLinksElement createDdeLinksElement()
    {
        OdfDdeLinksElement  nDdeLinks = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDdeLinksElement.class);
        this.appendChild( nDdeLinks);
        return  nDdeLinks;
    }                   
               
}
