/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;

import org.odftoolkit.odfdom.dom.element.config.OdfConfigItemSetElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:document-settings}.
 *
 */
public abstract class OdfDocumentSettingsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "document-settings" );

    /**
     * Create the instance of OdfDocumentSettingsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDocumentSettingsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:document-settings}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDocumentSettingsElement}
     *
     *@param version  The mandatory attribute {@attributeName  office:version}" 
     *
     */
    public void init(String version)
    {
        setVersion( version );
    }

    /**
     * Get value of attribute {@attributeName office:version}.
     *
     *@return return the attribute which type is String
     */
    public String getVersion()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "version" ) );
    }

    /**
     * Set value of attribute {@attributeName office:version}.
     *
     *@param  version    the attribute's type is String
     */ 
     public void setVersion( String version )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "version" ), version );
    }

    /**
     * Get value of attribute {@attributeName grddl:transformation}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getTransformation()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.GRDDL, "transformation" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName grddl:transformation}.
     *
     *@param  transformation    the attribute's type is OdfAnyURI
     */ 
     public void setTransformation( OdfAnyURI transformation )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.GRDDL, "transformation" ), transformation.toString() );
    }

    /**
    * Create child element {@odfLink config:config-item-set}.
    *
    *@param name String   
    *@return   return  the element {@odfLink config:config-item-set}
    */
    public OdfConfigItemSetElement createConfigItemSetElement(String   name)
    {
        OdfConfigItemSetElement  nConfigItemSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConfigItemSetElement.class);
        nConfigItemSet.setName( name);
        this.appendChild( nConfigItemSet);
        return  nConfigItemSet;      
    }
    
}
