/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;

import org.odftoolkit.odfdom.dom.element.meta.OdfGeneratorElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfTitleElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfDescriptionElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfSubjectElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfKeywordElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfInitialCreatorElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfCreatorElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfPrintedByElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfCreationDateElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfDateElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfPrintDateElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfTemplateElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.element.meta.OdfAutoReloadElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfHyperlinkBehaviourElement;
import org.odftoolkit.odfdom.dom.element.dc.OdfLanguageElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfEditingCyclesElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfEditingDurationElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfDocumentStatisticElement;
import org.odftoolkit.odfdom.dom.element.meta.OdfUserDefinedElement;
import org.odftoolkit.odfdom.dom.type.meta.OdfValueType;
import org.odftoolkit.odfdom.dom.element.config.OdfConfigItemSetElement;
import org.odftoolkit.odfdom.dom.element.style.OdfFontFaceElement;
import org.odftoolkit.odfdom.dom.element.style.OdfStyleElement;
import org.odftoolkit.odfdom.dom.element.text.OdfListStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfNumberStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfCurrencyStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfPercentageStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfDateStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfTimeStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfBooleanStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfTextStyleElement;
import org.odftoolkit.odfdom.dom.element.style.OdfDefaultStyleElement;
import org.odftoolkit.odfdom.dom.element.style.OdfDefaultPageLayoutElement;
import org.odftoolkit.odfdom.dom.element.text.OdfOutlineStyleElement;
import org.odftoolkit.odfdom.dom.element.text.OdfNotesConfigurationElement;
import org.odftoolkit.odfdom.dom.type.text.OdfNoteClassType;
import org.odftoolkit.odfdom.dom.element.text.OdfBibliographyConfigurationElement;
import org.odftoolkit.odfdom.dom.element.text.OdfLinenumberingConfigurationElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfGradientElement;
import org.odftoolkit.odfdom.dom.type.draw.OdfGradientStyleType;
import org.odftoolkit.odfdom.dom.element.svg.OdfLinearGradientElement;
import org.odftoolkit.odfdom.dom.element.svg.OdfRadialGradientElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfHatchElement;
import org.odftoolkit.odfdom.dom.type.draw.OdfHatchStyleType;
import org.odftoolkit.odfdom.dom.element.draw.OdfFillImageElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfMarkerElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfStrokeDashElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfOpacityElement;
import org.odftoolkit.odfdom.dom.element.style.OdfPresentationPageLayoutElement;
import org.odftoolkit.odfdom.dom.element.style.OdfPageLayoutElement;
import org.odftoolkit.odfdom.dom.element.style.OdfMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.OdfHandoutMasterElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfLayerSetElement;
import org.odftoolkit.odfdom.dom.element.table.OdfTableTemplateElement;
import org.odftoolkit.odfdom.dom.type.table.OdfRowOrColumnType;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:document}.
 *
 */
public abstract class OdfDocumentElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "document" );

    /**
     * Create the instance of OdfDocumentElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDocumentElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:document}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDocumentElement}
     *
     *@param mimetype  The mandatory attribute {@attributeName  office:mimetype}" 
     *@param version  The mandatory attribute {@attributeName  office:version}" 
     *
     */
    public void init(String mimetype, String version)
    {
        setMimetype( mimetype );
        setVersion( version );
    }

    /**
     * Get value of attribute {@attributeName office:mimetype}.
     *
     *@return return the attribute which type is String
     */
    public String getMimetype()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "mimetype" ) );
    }

    /**
     * Set value of attribute {@attributeName office:mimetype}.
     *
     *@param  mimetype    the attribute's type is String
     */ 
     public void setMimetype( String mimetype )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "mimetype" ), mimetype );
    }

    /**
     * Get value of attribute {@attributeName office:version}.
     *
     *@return return the attribute which type is String
     */
    public String getVersion()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "version" ) );
    }

    /**
     * Set value of attribute {@attributeName office:version}.
     *
     *@param  version    the attribute's type is String
     */ 
     public void setVersion( String version )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "version" ), version );
    }

    /**
     * Get value of attribute {@attributeName grddl:transformation}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getTransformation()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.GRDDL, "transformation" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName grddl:transformation}.
     *
     *@param  transformation    the attribute's type is OdfAnyURI
     */ 
     public void setTransformation( OdfAnyURI transformation )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.GRDDL, "transformation" ), transformation.toString() );
    }

    /**
    * Create child element {@odfLink meta:generator}.
    *
    *@return   return  the element {@odfLink meta:generator}
    */
    public OdfGeneratorElement createGeneratorElement()
    {
        OdfGeneratorElement  nGenerator = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGeneratorElement.class);
        this.appendChild( nGenerator);
        return  nGenerator;
    }                   
               
    /**
    * Create child element {@odfLink dc:title}.
    *
    *@return   return  the element {@odfLink dc:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink dc:description}.
    *
    *@return   return  the element {@odfLink dc:description}
    */
    public OdfDescriptionElement createDescriptionElement()
    {
        OdfDescriptionElement  nDescription = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescriptionElement.class);
        this.appendChild( nDescription);
        return  nDescription;
    }                   
               
    /**
    * Create child element {@odfLink dc:subject}.
    *
    *@return   return  the element {@odfLink dc:subject}
    */
    public OdfSubjectElement createSubjectElement()
    {
        OdfSubjectElement  nSubject = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSubjectElement.class);
        this.appendChild( nSubject);
        return  nSubject;
    }                   
               
    /**
    * Create child element {@odfLink meta:keyword}.
    *
    *@return   return  the element {@odfLink meta:keyword}
    */
    public OdfKeywordElement createKeywordElement()
    {
        OdfKeywordElement  nKeyword = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfKeywordElement.class);
        this.appendChild( nKeyword);
        return  nKeyword;
    }                   
               
    /**
    * Create child element {@odfLink meta:initial-creator}.
    *
    *@return   return  the element {@odfLink meta:initial-creator}
    */
    public OdfInitialCreatorElement createInitialCreatorElement()
    {
        OdfInitialCreatorElement  nInitialCreator = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfInitialCreatorElement.class);
        this.appendChild( nInitialCreator);
        return  nInitialCreator;
    }                   
               
    /**
    * Create child element {@odfLink dc:creator}.
    *
    *@return   return  the element {@odfLink dc:creator}
    */
    public OdfCreatorElement createCreatorElement()
    {
        OdfCreatorElement  nCreator = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCreatorElement.class);
        this.appendChild( nCreator);
        return  nCreator;
    }                   
               
    /**
    * Create child element {@odfLink meta:printed-by}.
    *
    *@return   return  the element {@odfLink meta:printed-by}
    */
    public OdfPrintedByElement createPrintedByElement()
    {
        OdfPrintedByElement  nPrintedBy = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPrintedByElement.class);
        this.appendChild( nPrintedBy);
        return  nPrintedBy;
    }                   
               
    /**
    * Create child element {@odfLink meta:creation-date}.
    *
    *@return   return  the element {@odfLink meta:creation-date}
    */
    public OdfCreationDateElement createCreationDateElement()
    {
        OdfCreationDateElement  nCreationDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCreationDateElement.class);
        this.appendChild( nCreationDate);
        return  nCreationDate;
    }                   
               
    /**
    * Create child element {@odfLink dc:date}.
    *
    *@return   return  the element {@odfLink dc:date}
    */
    public OdfDateElement createDateElement()
    {
        OdfDateElement  nDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDateElement.class);
        this.appendChild( nDate);
        return  nDate;
    }                   
               
    /**
    * Create child element {@odfLink meta:print-date}.
    *
    *@return   return  the element {@odfLink meta:print-date}
    */
    public OdfPrintDateElement createPrintDateElement()
    {
        OdfPrintDateElement  nPrintDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPrintDateElement.class);
        this.appendChild( nPrintDate);
        return  nPrintDate;
    }                   
               
    /**
    * Create child element {@odfLink meta:template}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink meta:template}
    */
    public OdfTemplateElement createTemplateElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfTemplateElement  nTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTemplateElement.class);
        nTemplate.setHref( href);
        this.appendChild( nTemplate);
        return  nTemplate;      
    }
    
    /**
    * Create child element {@odfLink meta:auto-reload}.
    *
    *@return   return  the element {@odfLink meta:auto-reload}
    */
    public OdfAutoReloadElement createAutoReloadElement()
    {
        OdfAutoReloadElement  nAutoReload = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAutoReloadElement.class);
        this.appendChild( nAutoReload);
        return  nAutoReload;
    }                   
               
    /**
    * Create child element {@odfLink meta:hyperlink-behaviour}.
    *
    *@return   return  the element {@odfLink meta:hyperlink-behaviour}
    */
    public OdfHyperlinkBehaviourElement createHyperlinkBehaviourElement()
    {
        OdfHyperlinkBehaviourElement  nHyperlinkBehaviour = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHyperlinkBehaviourElement.class);
        this.appendChild( nHyperlinkBehaviour);
        return  nHyperlinkBehaviour;
    }                   
               
    /**
    * Create child element {@odfLink dc:language}.
    *
    *@return   return  the element {@odfLink dc:language}
    */
    public OdfLanguageElement createLanguageElement()
    {
        OdfLanguageElement  nLanguage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLanguageElement.class);
        this.appendChild( nLanguage);
        return  nLanguage;
    }                   
               
    /**
    * Create child element {@odfLink meta:editing-cycles}.
    *
    *@return   return  the element {@odfLink meta:editing-cycles}
    */
    public OdfEditingCyclesElement createEditingCyclesElement()
    {
        OdfEditingCyclesElement  nEditingCycles = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEditingCyclesElement.class);
        this.appendChild( nEditingCycles);
        return  nEditingCycles;
    }                   
               
    /**
    * Create child element {@odfLink meta:editing-duration}.
    *
    *@return   return  the element {@odfLink meta:editing-duration}
    */
    public OdfEditingDurationElement createEditingDurationElement()
    {
        OdfEditingDurationElement  nEditingDuration = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEditingDurationElement.class);
        this.appendChild( nEditingDuration);
        return  nEditingDuration;
    }                   
               
    /**
    * Create child element {@odfLink meta:document-statistic}.
    *
    *@return   return  the element {@odfLink meta:document-statistic}
    */
    public OdfDocumentStatisticElement createDocumentStatisticElement()
    {
        OdfDocumentStatisticElement  nDocumentStatistic = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDocumentStatisticElement.class);
        this.appendChild( nDocumentStatistic);
        return  nDocumentStatistic;
    }                   
               
    /**
    * Create child element {@odfLink meta:user-defined}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  meta:value-type} at specification
    *@param name String   
    *@return   return  the element {@odfLink meta:user-defined}
    */
    public OdfUserDefinedElement createUserDefinedElement(OdfValueType   valueType, String   name)
    {
        OdfUserDefinedElement  nUserDefined = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserDefinedElement.class);
        nUserDefined.setValueType( valueType);
        nUserDefined.setName( name);
        this.appendChild( nUserDefined);
        return  nUserDefined;      
    }
    
    /**
    * Create child element {@odfLink config:config-item-set}.
    *
    *@param name String   
    *@return   return  the element {@odfLink config:config-item-set}
    */
    public OdfConfigItemSetElement createConfigItemSetElement(String   name)
    {
        OdfConfigItemSetElement  nConfigItemSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConfigItemSetElement.class);
        nConfigItemSet.setName( name);
        this.appendChild( nConfigItemSet);
        return  nConfigItemSet;      
    }
    
    /**
    * Create child element {@odfLink office:script}.
    *
    *@param language String   
    *@return   return  the element {@odfLink office:script}
    */
    public OdfScriptElement createScriptElement(String   language)
    {
        OdfScriptElement  nScript = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfScriptElement.class);
        nScript.setLanguage( language);
        this.appendChild( nScript);
        return  nScript;      
    }
    
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
    /**
    * Create child element {@odfLink style:font-face}.
    *
    *@param name String   
    *@return   return  the element {@odfLink style:font-face}
    */
    public OdfFontFaceElement createFontFaceElement(String   name)
    {
        OdfFontFaceElement  nFontFace = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFontFaceElement.class);
        nFontFace.setName( name);
        this.appendChild( nFontFace);
        return  nFontFace;      
    }
    
    /**
    * Create child element {@odfLink style:style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink style:style}
    */
    public OdfStyleElement createStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfStyleElement  nStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfStyleElement.class);
        nStyle.setName( name);
        this.appendChild( nStyle);
        return  nStyle;      
    }
    
    /**
    * Create child element {@odfLink text:list-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink text:list-style}
    */
    public OdfListStyleElement createListStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfListStyleElement  nListStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListStyleElement.class);
        nListStyle.setName( name);
        this.appendChild( nListStyle);
        return  nListStyle;      
    }
    
    /**
    * Create child element {@odfLink number:number-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:number-style}
    */
    public OdfNumberStyleElement createNumberStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfNumberStyleElement  nNumberStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNumberStyleElement.class);
        nNumberStyle.setName( name);
        this.appendChild( nNumberStyle);
        return  nNumberStyle;      
    }
    
    /**
    * Create child element {@odfLink number:currency-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:currency-style}
    */
    public OdfCurrencyStyleElement createCurrencyStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfCurrencyStyleElement  nCurrencyStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCurrencyStyleElement.class);
        nCurrencyStyle.setName( name);
        this.appendChild( nCurrencyStyle);
        return  nCurrencyStyle;      
    }
    
    /**
    * Create child element {@odfLink number:percentage-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:percentage-style}
    */
    public OdfPercentageStyleElement createPercentageStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfPercentageStyleElement  nPercentageStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPercentageStyleElement.class);
        nPercentageStyle.setName( name);
        this.appendChild( nPercentageStyle);
        return  nPercentageStyle;      
    }
    
    /**
    * Create child element {@odfLink number:date-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:date-style}
    */
    public OdfDateStyleElement createDateStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfDateStyleElement  nDateStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDateStyleElement.class);
        nDateStyle.setName( name);
        this.appendChild( nDateStyle);
        return  nDateStyle;      
    }
    
    /**
    * Create child element {@odfLink number:time-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:time-style}
    */
    public OdfTimeStyleElement createTimeStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfTimeStyleElement  nTimeStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTimeStyleElement.class);
        nTimeStyle.setName( name);
        this.appendChild( nTimeStyle);
        return  nTimeStyle;      
    }
    
    /**
    * Create child element {@odfLink number:boolean-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:boolean-style}
    */
    public OdfBooleanStyleElement createBooleanStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfBooleanStyleElement  nBooleanStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBooleanStyleElement.class);
        nBooleanStyle.setName( name);
        this.appendChild( nBooleanStyle);
        return  nBooleanStyle;      
    }
    
    /**
    * Create child element {@odfLink number:text-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:text-style}
    */
    public OdfTextStyleElement createTextStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfTextStyleElement  nTextStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextStyleElement.class);
        nTextStyle.setName( name);
        this.appendChild( nTextStyle);
        return  nTextStyle;      
    }
    
    /**
    * Create child element {@odfLink style:default-style}.
    *
    *@return   return  the element {@odfLink style:default-style}
    */
    public OdfDefaultStyleElement createDefaultStyleElement()
    {
        OdfDefaultStyleElement  nDefaultStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDefaultStyleElement.class);
        this.appendChild( nDefaultStyle);
        return  nDefaultStyle;
    }                   
               
    /**
    * Create child element {@odfLink style:default-page-layout}.
    *
    *@return   return  the element {@odfLink style:default-page-layout}
    */
    public OdfDefaultPageLayoutElement createDefaultPageLayoutElement()
    {
        OdfDefaultPageLayoutElement  nDefaultPageLayout = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDefaultPageLayoutElement.class);
        this.appendChild( nDefaultPageLayout);
        return  nDefaultPageLayout;
    }                   
               
    /**
    * Create child element {@odfLink text:outline-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink text:outline-style}
    */
    public OdfOutlineStyleElement createOutlineStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfOutlineStyleElement  nOutlineStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfOutlineStyleElement.class);
        nOutlineStyle.setName( name);
        this.appendChild( nOutlineStyle);
        return  nOutlineStyle;      
    }
    
    /**
    * Create child element {@odfLink text:notes-configuration}.
    *
    *@param noteClass     the attribute's type is OdfNoteClassType, see {@attributeName  text:note-class} at specification
    *@return   return  the element {@odfLink text:notes-configuration}
    */
    public OdfNotesConfigurationElement createNotesConfigurationElement(OdfNoteClassType   noteClass)
    {
        OdfNotesConfigurationElement  nNotesConfiguration = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNotesConfigurationElement.class);
        nNotesConfiguration.setNoteClass( noteClass);
        this.appendChild( nNotesConfiguration);
        return  nNotesConfiguration;      
    }
    
    /**
    * Create child element {@odfLink text:bibliography-configuration}.
    *
    *@return   return  the element {@odfLink text:bibliography-configuration}
    */
    public OdfBibliographyConfigurationElement createBibliographyConfigurationElement()
    {
        OdfBibliographyConfigurationElement  nBibliographyConfiguration = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBibliographyConfigurationElement.class);
        this.appendChild( nBibliographyConfiguration);
        return  nBibliographyConfiguration;
    }                   
               
    /**
    * Create child element {@odfLink text:linenumbering-configuration}.
    *
    *@return   return  the element {@odfLink text:linenumbering-configuration}
    */
    public OdfLinenumberingConfigurationElement createLinenumberingConfigurationElement()
    {
        OdfLinenumberingConfigurationElement  nLinenumberingConfiguration = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLinenumberingConfigurationElement.class);
        this.appendChild( nLinenumberingConfiguration);
        return  nLinenumberingConfiguration;
    }                   
               
    /**
    * Create child element {@odfLink draw:gradient}.
    *
    *@param style     the attribute's type is OdfGradientStyleType, see {@attributeName  draw:gradient-style} at specification
    *@return   return  the element {@odfLink draw:gradient}
    */
    public OdfGradientElement createGradientElement(OdfGradientStyleType   style)
    {
        OdfGradientElement  nGradient = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGradientElement.class);
        nGradient.setStyle( style);
        this.appendChild( nGradient);
        return  nGradient;      
    }
    
    /**
    * Create child element {@odfLink svg:linearGradient}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink svg:linearGradient}
    */
    public OdfLinearGradientElement createLinearGradientElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfLinearGradientElement  nLinearGradient = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLinearGradientElement.class);
        nLinearGradient.setName( name);
        this.appendChild( nLinearGradient);
        return  nLinearGradient;      
    }
    
    /**
    * Create child element {@odfLink svg:radialGradient}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink svg:radialGradient}
    */
    public OdfRadialGradientElement createRadialGradientElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfRadialGradientElement  nRadialGradient = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRadialGradientElement.class);
        nRadialGradient.setName( name);
        this.appendChild( nRadialGradient);
        return  nRadialGradient;      
    }
    
    /**
    * Create child element {@odfLink draw:hatch}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@param style     the attribute's type is OdfHatchStyleType, see {@attributeName  draw:hatch-style} at specification
    *@return   return  the element {@odfLink draw:hatch}
    */
    public OdfHatchElement createHatchElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name, OdfHatchStyleType   style)
    {
        OdfHatchElement  nHatch = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHatchElement.class);
        nHatch.setName( name);
        nHatch.setStyle( style);
        this.appendChild( nHatch);
        return  nHatch;      
    }
    
    /**
    * Create child element {@odfLink draw:fill-image}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink draw:fill-image}
    */
    public OdfFillImageElement createFillImageElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name, org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfFillImageElement  nFillImage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFillImageElement.class);
        nFillImage.setName( name);
        nFillImage.setHref( href);
        this.appendChild( nFillImage);
        return  nFillImage;      
    }
    
    /**
    * Create child element {@odfLink draw:marker}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@param viewBox Integer   
    *@param d String   
    *@return   return  the element {@odfLink draw:marker}
    */
    public OdfMarkerElement createMarkerElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name, Integer   viewBox, String   d)
    {
        OdfMarkerElement  nMarker = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMarkerElement.class);
        nMarker.setName( name);
        nMarker.setViewBox( viewBox);
        nMarker.setD( d);
        this.appendChild( nMarker);
        return  nMarker;      
    }
    
    /**
    * Create child element {@odfLink draw:stroke-dash}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink draw:stroke-dash}
    */
    public OdfStrokeDashElement createStrokeDashElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfStrokeDashElement  nStrokeDash = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfStrokeDashElement.class);
        nStrokeDash.setName( name);
        this.appendChild( nStrokeDash);
        return  nStrokeDash;      
    }
    
    /**
    * Create child element {@odfLink draw:opacity}.
    *
    *@param style     the attribute's type is OdfGradientStyleType, see {@attributeName  draw:gradient-style} at specification
    *@return   return  the element {@odfLink draw:opacity}
    */
    public OdfOpacityElement createOpacityElement(OdfGradientStyleType   style)
    {
        OdfOpacityElement  nOpacity = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfOpacityElement.class);
        nOpacity.setStyle( style);
        this.appendChild( nOpacity);
        return  nOpacity;      
    }
    
    /**
    * Create child element {@odfLink style:presentation-page-layout}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink style:presentation-page-layout}
    */
    public OdfPresentationPageLayoutElement createPresentationPageLayoutElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfPresentationPageLayoutElement  nPresentationPageLayout = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPresentationPageLayoutElement.class);
        nPresentationPageLayout.setName( name);
        this.appendChild( nPresentationPageLayout);
        return  nPresentationPageLayout;      
    }
    
    /**
    * Create child element {@odfLink style:page-layout}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink style:page-layout}
    */
    public OdfPageLayoutElement createPageLayoutElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfPageLayoutElement  nPageLayout = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageLayoutElement.class);
        nPageLayout.setName( name);
        this.appendChild( nPageLayout);
        return  nPageLayout;      
    }
    
    /**
    * Create child element {@odfLink style:master-page}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@param pageLayoutName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink style:master-page}
    */
    public OdfMasterPageElement createMasterPageElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name, org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   pageLayoutName)
    {
        OdfMasterPageElement  nMasterPage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMasterPageElement.class);
        nMasterPage.setName( name);
        nMasterPage.setPageLayoutName( pageLayoutName);
        this.appendChild( nMasterPage);
        return  nMasterPage;      
    }
    
    /**
    * Create child element {@odfLink style:handout-master}.
    *
    *@param pageLayoutName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink style:handout-master}
    */
    public OdfHandoutMasterElement createHandoutMasterElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   pageLayoutName)
    {
        OdfHandoutMasterElement  nHandoutMaster = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHandoutMasterElement.class);
        nHandoutMaster.setPageLayoutName( pageLayoutName);
        this.appendChild( nHandoutMaster);
        return  nHandoutMaster;      
    }
    
    /**
    * Create child element {@odfLink draw:layer-set}.
    *
    *@return   return  the element {@odfLink draw:layer-set}
    */
    public OdfLayerSetElement createLayerSetElement()
    {
        OdfLayerSetElement  nLayerSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLayerSetElement.class);
        this.appendChild( nLayerSet);
        return  nLayerSet;
    }                   
               
    /**
    * Create child element {@odfLink table:table-template}.
    *
    *@param name String   
    *@param firstRowStartColumn     the attribute's type is OdfRowOrColumnType, see {@attributeName  table:row-or-column} at specification
    *@param firstRowEndColumn     the attribute's type is OdfRowOrColumnType, see {@attributeName  table:row-or-column} at specification
    *@param lastRowStartColumn     the attribute's type is OdfRowOrColumnType, see {@attributeName  table:row-or-column} at specification
    *@param lastRowEndColumn     the attribute's type is OdfRowOrColumnType, see {@attributeName  table:row-or-column} at specification
    *@return   return  the element {@odfLink table:table-template}
    */
    public OdfTableTemplateElement createTableTemplateElement(String   name, OdfRowOrColumnType   firstRowStartColumn, OdfRowOrColumnType   firstRowEndColumn, OdfRowOrColumnType   lastRowStartColumn, OdfRowOrColumnType   lastRowEndColumn)
    {
        OdfTableTemplateElement  nTableTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableTemplateElement.class);
        nTableTemplate.setName( name);
        nTableTemplate.setFirstRowStartColumn( firstRowStartColumn);
        nTableTemplate.setFirstRowEndColumn( firstRowEndColumn);
        nTableTemplate.setLastRowStartColumn( lastRowStartColumn);
        nTableTemplate.setLastRowEndColumn( lastRowEndColumn);
        this.appendChild( nTableTemplate);
        return  nTableTemplate;      
    }
    
    /**
    * Create child element {@odfLink office:body}.
    *
    *@return   return  the element {@odfLink office:body}
    */
    public OdfBodyElement createBodyElement()
    {
        OdfBodyElement  nBody = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBodyElement.class);
        this.appendChild( nBody);
        return  nBody;
    }                   
               
}
