/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;

import org.odftoolkit.odfdom.dom.element.style.OdfFontFaceElement;
import org.odftoolkit.odfdom.dom.element.style.OdfStyleElement;
import org.odftoolkit.odfdom.dom.element.text.OdfListStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfNumberStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfCurrencyStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfPercentageStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfDateStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfTimeStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfBooleanStyleElement;
import org.odftoolkit.odfdom.dom.element.number.OdfTextStyleElement;
import org.odftoolkit.odfdom.dom.element.style.OdfPageLayoutElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:document-content}.
 *
 */
public abstract class OdfDocumentContentElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "document-content" );

    /**
     * Create the instance of OdfDocumentContentElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDocumentContentElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:document-content}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDocumentContentElement}
     *
     *@param version  The mandatory attribute {@attributeName  office:version}" 
     *
     */
    public void init(String version)
    {
        setVersion( version );
    }

    /**
     * Get value of attribute {@attributeName office:version}.
     *
     *@return return the attribute which type is String
     */
    public String getVersion()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "version" ) );
    }

    /**
     * Set value of attribute {@attributeName office:version}.
     *
     *@param  version    the attribute's type is String
     */ 
     public void setVersion( String version )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "version" ), version );
    }

    /**
     * Get value of attribute {@attributeName grddl:transformation}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getTransformation()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.GRDDL, "transformation" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName grddl:transformation}.
     *
     *@param  transformation    the attribute's type is OdfAnyURI
     */ 
     public void setTransformation( OdfAnyURI transformation )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.GRDDL, "transformation" ), transformation.toString() );
    }

    /**
    * Create child element {@odfLink office:script}.
    *
    *@param language String   
    *@return   return  the element {@odfLink office:script}
    */
    public OdfScriptElement createScriptElement(String   language)
    {
        OdfScriptElement  nScript = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfScriptElement.class);
        nScript.setLanguage( language);
        this.appendChild( nScript);
        return  nScript;      
    }
    
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
    /**
    * Create child element {@odfLink style:font-face}.
    *
    *@param name String   
    *@return   return  the element {@odfLink style:font-face}
    */
    public OdfFontFaceElement createFontFaceElement(String   name)
    {
        OdfFontFaceElement  nFontFace = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFontFaceElement.class);
        nFontFace.setName( name);
        this.appendChild( nFontFace);
        return  nFontFace;      
    }
    
    /**
    * Create child element {@odfLink style:style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink style:style}
    */
    public OdfStyleElement createStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfStyleElement  nStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfStyleElement.class);
        nStyle.setName( name);
        this.appendChild( nStyle);
        return  nStyle;      
    }
    
    /**
    * Create child element {@odfLink text:list-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink text:list-style}
    */
    public OdfListStyleElement createListStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfListStyleElement  nListStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListStyleElement.class);
        nListStyle.setName( name);
        this.appendChild( nListStyle);
        return  nListStyle;      
    }
    
    /**
    * Create child element {@odfLink number:number-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:number-style}
    */
    public OdfNumberStyleElement createNumberStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfNumberStyleElement  nNumberStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNumberStyleElement.class);
        nNumberStyle.setName( name);
        this.appendChild( nNumberStyle);
        return  nNumberStyle;      
    }
    
    /**
    * Create child element {@odfLink number:currency-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:currency-style}
    */
    public OdfCurrencyStyleElement createCurrencyStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfCurrencyStyleElement  nCurrencyStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCurrencyStyleElement.class);
        nCurrencyStyle.setName( name);
        this.appendChild( nCurrencyStyle);
        return  nCurrencyStyle;      
    }
    
    /**
    * Create child element {@odfLink number:percentage-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:percentage-style}
    */
    public OdfPercentageStyleElement createPercentageStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfPercentageStyleElement  nPercentageStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPercentageStyleElement.class);
        nPercentageStyle.setName( name);
        this.appendChild( nPercentageStyle);
        return  nPercentageStyle;      
    }
    
    /**
    * Create child element {@odfLink number:date-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:date-style}
    */
    public OdfDateStyleElement createDateStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfDateStyleElement  nDateStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDateStyleElement.class);
        nDateStyle.setName( name);
        this.appendChild( nDateStyle);
        return  nDateStyle;      
    }
    
    /**
    * Create child element {@odfLink number:time-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:time-style}
    */
    public OdfTimeStyleElement createTimeStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfTimeStyleElement  nTimeStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTimeStyleElement.class);
        nTimeStyle.setName( name);
        this.appendChild( nTimeStyle);
        return  nTimeStyle;      
    }
    
    /**
    * Create child element {@odfLink number:boolean-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:boolean-style}
    */
    public OdfBooleanStyleElement createBooleanStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfBooleanStyleElement  nBooleanStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBooleanStyleElement.class);
        nBooleanStyle.setName( name);
        this.appendChild( nBooleanStyle);
        return  nBooleanStyle;      
    }
    
    /**
    * Create child element {@odfLink number:text-style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink number:text-style}
    */
    public OdfTextStyleElement createTextStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfTextStyleElement  nTextStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextStyleElement.class);
        nTextStyle.setName( name);
        this.appendChild( nTextStyle);
        return  nTextStyle;      
    }
    
    /**
    * Create child element {@odfLink style:page-layout}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink style:page-layout}
    */
    public OdfPageLayoutElement createPageLayoutElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfPageLayoutElement  nPageLayout = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageLayoutElement.class);
        nPageLayout.setName( name);
        this.appendChild( nPageLayout);
        return  nPageLayout;      
    }
    
    /**
    * Create child element {@odfLink office:body}.
    *
    *@return   return  the element {@odfLink office:body}
    */
    public OdfBodyElement createBodyElement()
    {
        OdfBodyElement  nBody = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBodyElement.class);
        this.appendChild( nBody);
        return  nBody;
    }                   
               
}
