/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.office.OdfConversionModeType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:dde-source}.
 *
 */
public abstract class OdfDdeSourceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "dde-source" );

    /**
     * Create the instance of OdfDdeSourceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDdeSourceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:dde-source}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDdeSourceElement}
     *
     *@param ddeApplication  The mandatory attribute {@attributeName  office:dde-application}" 
     *@param ddeTopic  The mandatory attribute {@attributeName  office:dde-topic}" 
     *@param ddeItem  The mandatory attribute {@attributeName  office:dde-item}" 
     *
     */
    public void init(String ddeApplication, String ddeTopic, String ddeItem)
    {
        setDdeApplication( ddeApplication );
        setDdeTopic( ddeTopic );
        setDdeItem( ddeItem );
    }

    /**
     * Get value of attribute {@attributeName office:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName office:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName office:conversion-mode}.
     *
     *@return return the attribute which type is OdfConversionModeType
     */
    public OdfConversionModeType getConversionMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "conversion-mode" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "into-default-style-data-style";
        }

        return OdfConversionModeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:conversion-mode}.
     *
     *@param  conversionMode    the attribute's type is OdfConversionModeType
     */ 
     public void setConversionMode( OdfConversionModeType conversionMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "conversion-mode" ), conversionMode.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:dde-application}.
     *
     *@return return the attribute which type is String
     */
    public String getDdeApplication()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "dde-application" ) );
    }

    /**
     * Set value of attribute {@attributeName office:dde-application}.
     *
     *@param  ddeApplication    the attribute's type is String
     */ 
     public void setDdeApplication( String ddeApplication )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "dde-application" ), ddeApplication );
    }

    /**
     * Get value of attribute {@attributeName office:dde-topic}.
     *
     *@return return the attribute which type is String
     */
    public String getDdeTopic()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "dde-topic" ) );
    }

    /**
     * Set value of attribute {@attributeName office:dde-topic}.
     *
     *@param  ddeTopic    the attribute's type is String
     */ 
     public void setDdeTopic( String ddeTopic )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "dde-topic" ), ddeTopic );
    }

    /**
     * Get value of attribute {@attributeName office:dde-item}.
     *
     *@return return the attribute which type is String
     */
    public String getDdeItem()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "dde-item" ) );
    }

    /**
     * Set value of attribute {@attributeName office:dde-item}.
     *
     *@param  ddeItem    the attribute's type is String
     */ 
     public void setDdeItem( String ddeItem )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "dde-item" ), ddeItem );
    }

    /**
     * Get value of attribute {@attributeName office:automatic-update}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAutomaticUpdate()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "automatic-update" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:automatic-update}.
     *
     *@param  isAutomaticUpdate    the attribute's type is OdfBoolean
     */ 
     public void setAutomaticUpdate( OdfBoolean isAutomaticUpdate )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "automatic-update" ), isAutomaticUpdate.toString() );
    }

}
