/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import org.odftoolkit.odfdom.dom.element.db.OdfDataSourceElement;
import org.odftoolkit.odfdom.dom.element.db.OdfFormsElement;
import org.odftoolkit.odfdom.dom.element.db.OdfReportsElement;
import org.odftoolkit.odfdom.dom.element.db.OdfQueriesElement;
import org.odftoolkit.odfdom.dom.element.db.OdfTableRepresentationsElement;
import org.odftoolkit.odfdom.dom.element.db.OdfSchemaDefinitionElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:database}.
 *
 */
public abstract class OdfDatabaseElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "database" );

    /**
     * Create the instance of OdfDatabaseElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDatabaseElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:database}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink db:data-source}.
    *
    *@return   return  the element {@odfLink db:data-source}
    */
    public OdfDataSourceElement createDataSourceElement()
    {
        OdfDataSourceElement  nDataSource = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataSourceElement.class);
        this.appendChild( nDataSource);
        return  nDataSource;
    }                   
               
    /**
    * Create child element {@odfLink db:forms}.
    *
    *@return   return  the element {@odfLink db:forms}
    */
    public OdfFormsElement createFormsElement()
    {
        OdfFormsElement  nForms = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFormsElement.class);
        this.appendChild( nForms);
        return  nForms;
    }                   
               
    /**
    * Create child element {@odfLink db:reports}.
    *
    *@return   return  the element {@odfLink db:reports}
    */
    public OdfReportsElement createReportsElement()
    {
        OdfReportsElement  nReports = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfReportsElement.class);
        this.appendChild( nReports);
        return  nReports;
    }                   
               
    /**
    * Create child element {@odfLink db:queries}.
    *
    *@return   return  the element {@odfLink db:queries}
    */
    public OdfQueriesElement createQueriesElement()
    {
        OdfQueriesElement  nQueries = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfQueriesElement.class);
        this.appendChild( nQueries);
        return  nQueries;
    }                   
               
    /**
    * Create child element {@odfLink db:table-representations}.
    *
    *@return   return  the element {@odfLink db:table-representations}
    */
    public OdfTableRepresentationsElement createTableRepresentationsElement()
    {
        OdfTableRepresentationsElement  nTableRepresentations = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableRepresentationsElement.class);
        this.appendChild( nTableRepresentations);
        return  nTableRepresentations;
    }                   
               
    /**
    * Create child element {@odfLink db:schema-definition}.
    *
    *@return   return  the element {@odfLink db:schema-definition}
    */
    public OdfSchemaDefinitionElement createSchemaDefinitionElement()
    {
        OdfSchemaDefinitionElement  nSchemaDefinition = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSchemaDefinitionElement.class);
        this.appendChild( nSchemaDefinition);
        return  nSchemaDefinition;
    }                   
               
}
