/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink office:body}.
 *
 */
public abstract class OdfBodyElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.OFFICE, "body" );

    /**
     * Create the instance of OdfBodyElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfBodyElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink office:body}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink office:text}.
    *
    *@return   return  the element {@odfLink office:text}
    */
    public OdfTextElement createTextElement()
    {
        OdfTextElement  nText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextElement.class);
        this.appendChild( nText);
        return  nText;
    }                   
               
    /**
    * Create child element {@odfLink office:drawing}.
    *
    *@return   return  the element {@odfLink office:drawing}
    */
    public OdfDrawingElement createDrawingElement()
    {
        OdfDrawingElement  nDrawing = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDrawingElement.class);
        this.appendChild( nDrawing);
        return  nDrawing;
    }                   
               
    /**
    * Create child element {@odfLink office:presentation}.
    *
    *@return   return  the element {@odfLink office:presentation}
    */
    public OdfPresentationElement createPresentationElement()
    {
        OdfPresentationElement  nPresentation = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPresentationElement.class);
        this.appendChild( nPresentation);
        return  nPresentation;
    }                   
               
    /**
    * Create child element {@odfLink office:spreadsheet}.
    *
    *@return   return  the element {@odfLink office:spreadsheet}
    */
    public OdfSpreadsheetElement createSpreadsheetElement()
    {
        OdfSpreadsheetElement  nSpreadsheet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSpreadsheetElement.class);
        this.appendChild( nSpreadsheet);
        return  nSpreadsheet;
    }                   
               
    /**
    * Create child element {@odfLink office:chart}.
    *
    *@return   return  the element {@odfLink office:chart}
    */
    public OdfChartElement createChartElement()
    {
        OdfChartElement  nChart = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfChartElement.class);
        this.appendChild( nChart);
        return  nChart;
    }                   
               
    /**
    * Create child element {@odfLink office:image}.
    *
    *@return   return  the element {@odfLink office:image}
    */
    public OdfImageElement createImageElement()
    {
        OdfImageElement  nImage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfImageElement.class);
        this.appendChild( nImage);
        return  nImage;
    }                   
               
    /**
    * Create child element {@odfLink office:database}.
    *
    *@return   return  the element {@odfLink office:database}
    */
    public OdfDatabaseElement createDatabaseElement()
    {
        OdfDatabaseElement  nDatabase = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseElement.class);
        this.appendChild( nDatabase);
        return  nDatabase;
    }                   
               
}
