/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.number;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink number:scientific-number}.
 *
 */
public abstract class OdfScientificNumberElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.NUMBER, "scientific-number" );

    /**
     * Create the instance of OdfScientificNumberElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfScientificNumberElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink number:scientific-number}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName number:min-exponent-digits}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getMinExponentDigits()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "min-exponent-digits" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName number:min-exponent-digits}.
     *
     *@param  minExponentDigits    the attribute's type is Integer
     */ 
     public void setMinExponentDigits( Integer minExponentDigits )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "min-exponent-digits" ), minExponentDigits.toString() );
    }

    /**
     * Get value of attribute {@attributeName number:decimal-places}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getDecimalPlaces()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "decimal-places" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName number:decimal-places}.
     *
     *@param  decimalPlaces    the attribute's type is Integer
     */ 
     public void setDecimalPlaces( Integer decimalPlaces )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "decimal-places" ), decimalPlaces.toString() );
    }

    /**
     * Get value of attribute {@attributeName number:min-integer-digits}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getMinIntegerDigits()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "min-integer-digits" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName number:min-integer-digits}.
     *
     *@param  minIntegerDigits    the attribute's type is Integer
     */ 
     public void setMinIntegerDigits( Integer minIntegerDigits )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "min-integer-digits" ), minIntegerDigits.toString() );
    }

    /**
     * Get value of attribute {@attributeName number:grouping}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getGrouping()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "grouping" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName number:grouping}.
     *
     *@param  isGrouping    the attribute's type is OdfBoolean
     */ 
     public void setGrouping( OdfBoolean isGrouping )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "grouping" ), isGrouping.toString() );
    }

}
