/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.number;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.number.OdfStyleType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink number:day-of-week}.
 *
 */
public abstract class OdfDayOfWeekElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.NUMBER, "day-of-week" );

    /**
     * Create the instance of OdfDayOfWeekElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDayOfWeekElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink number:day-of-week}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName number:style}.
     *
     *@return return the attribute which type is OdfStyleType
     */
    public OdfStyleType getStyle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "style" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "short";
        }

        return OdfStyleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName number:style}.
     *
     *@param  style    the attribute's type is OdfStyleType
     */ 
     public void setStyle( OdfStyleType style )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "style" ), style.toString() );
    }

    /**
     * Get value of attribute {@attributeName number:calendar}.
     *
     *@return return the attribute which type is String
     */
    public String getCalendar()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "calendar" ) );
    }

    /**
     * Set value of attribute {@attributeName number:calendar}.
     *
     *@param  calendar    the attribute's type is String
     */ 
     public void setCalendar( String calendar )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "calendar" ), calendar );
    }

}
