/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.number;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.number.OdfTransliterationStyleType;
import org.odftoolkit.odfdom.dom.type.number.OdfFormatSourceType;

import org.odftoolkit.odfdom.dom.element.style.OdfTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfMapElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink number:date-style}.
 *
 */
public abstract class OdfDateStyleElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.NUMBER, "date-style" );

    /**
     * Create the instance of OdfDateStyleElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDateStyleElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink number:date-style}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDateStyleElement}
     *
     *@param name  The mandatory attribute {@attributeName  style:name}" 
     *
     */
    public void init(OdfStyleName name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName style:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName number:language}.
     *
     *@return return the attribute which type is String
     */
    public String getLanguage()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "language" ) );
    }

    /**
     * Set value of attribute {@attributeName number:language}.
     *
     *@param  language    the attribute's type is String
     */ 
     public void setLanguage( String language )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "language" ), language );
    }

    /**
     * Get value of attribute {@attributeName number:country}.
     *
     *@return return the attribute which type is String
     */
    public String getCountry()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "country" ) );
    }

    /**
     * Set value of attribute {@attributeName number:country}.
     *
     *@param  country    the attribute's type is String
     */ 
     public void setCountry( String country )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "country" ), country );
    }

    /**
     * Get value of attribute {@attributeName number:script}.
     *
     *@return return the attribute which type is String
     */
    public String getScript()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "script" ) );
    }

    /**
     * Set value of attribute {@attributeName number:script}.
     *
     *@param  script    the attribute's type is String
     */ 
     public void setScript( String script )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "script" ), script );
    }

    /**
     * Get value of attribute {@attributeName number:rfc-language-tag}.
     *
     *@return return the attribute which type is String
     */
    public String getRfcLanguageTag()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "rfc-language-tag" ) );
    }

    /**
     * Set value of attribute {@attributeName number:rfc-language-tag}.
     *
     *@param  rfcLanguageTag    the attribute's type is String
     */ 
     public void setRfcLanguageTag( String rfcLanguageTag )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "rfc-language-tag" ), rfcLanguageTag );
    }

    /**
     * Get value of attribute {@attributeName number:title}.
     *
     *@return return the attribute which type is String
     */
    public String getTitle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "title" ) );
    }

    /**
     * Set value of attribute {@attributeName number:title}.
     *
     *@param  title    the attribute's type is String
     */ 
     public void setTitle( String title )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "title" ), title );
    }

    /**
     * Get value of attribute {@attributeName style:volatile}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getVolatile()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "volatile" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:volatile}.
     *
     *@param  isVolatile    the attribute's type is OdfBoolean
     */ 
     public void setVolatile( OdfBoolean isVolatile )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "volatile" ), isVolatile.toString() );
    }

    /**
     * Get value of attribute {@attributeName number:transliteration-format}.
     *
     *@return return the attribute which type is String
     */
    public String getTransliterationFormat()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-format" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "1";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName number:transliteration-format}.
     *
     *@param  transliterationFormat    the attribute's type is String
     */ 
     public void setTransliterationFormat( String transliterationFormat )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-format" ), transliterationFormat );
    }

    /**
     * Get value of attribute {@attributeName number:transliteration-language}.
     *
     *@return return the attribute which type is String
     */
    public String getTransliterationLanguage()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-language" ) );
    }

    /**
     * Set value of attribute {@attributeName number:transliteration-language}.
     *
     *@param  transliterationLanguage    the attribute's type is String
     */ 
     public void setTransliterationLanguage( String transliterationLanguage )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-language" ), transliterationLanguage );
    }

    /**
     * Get value of attribute {@attributeName number:transliteration-country}.
     *
     *@return return the attribute which type is String
     */
    public String getTransliterationCountry()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-country" ) );
    }

    /**
     * Set value of attribute {@attributeName number:transliteration-country}.
     *
     *@param  transliterationCountry    the attribute's type is String
     */ 
     public void setTransliterationCountry( String transliterationCountry )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-country" ), transliterationCountry );
    }

    /**
     * Get value of attribute {@attributeName number:transliteration-style}.
     *
     *@return return the attribute which type is OdfTransliterationStyleType
     */
    public OdfTransliterationStyleType getTransliterationStyle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-style" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "short";
        }

        return OdfTransliterationStyleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName number:transliteration-style}.
     *
     *@param  transliterationStyle    the attribute's type is OdfTransliterationStyleType
     */ 
     public void setTransliterationStyle( OdfTransliterationStyleType transliterationStyle )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-style" ), transliterationStyle.toString() );
    }

    /**
     * Get value of attribute {@attributeName number:automatic-order}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAutomaticOrder()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "automatic-order" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName number:automatic-order}.
     *
     *@param  isAutomaticOrder    the attribute's type is OdfBoolean
     */ 
     public void setAutomaticOrder( OdfBoolean isAutomaticOrder )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "automatic-order" ), isAutomaticOrder.toString() );
    }

    /**
     * Get value of attribute {@attributeName number:format-source}.
     *
     *@return return the attribute which type is OdfFormatSourceType
     */
    public OdfFormatSourceType getFormatSource()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "format-source" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "fixed";
        }

        return OdfFormatSourceType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName number:format-source}.
     *
     *@param  formatSource    the attribute's type is OdfFormatSourceType
     */ 
     public void setFormatSource( OdfFormatSourceType formatSource )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "format-source" ), formatSource.toString() );
    }

    /**
    * Create child element {@odfLink style:text-properties}.
    *
    *@param display String   
    *@return   return  the element {@odfLink style:text-properties}
    */
    public OdfTextPropertiesElement createTextPropertiesElement(String   display)
    {
        OdfTextPropertiesElement  nTextProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextPropertiesElement.class);
        this.appendChild( nTextProperties);
        return  nTextProperties;      
    }
    
    /**
    * Create child element {@odfLink style:text-properties}.
    *
    *@param display String   
    *@param condition String   
    *@return   return  the element {@odfLink style:text-properties}
    */
    public OdfTextPropertiesElement createTextPropertiesElement(String   display, String   condition)
    {
        OdfTextPropertiesElement  nTextProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextPropertiesElement.class);
        this.appendChild( nTextProperties);
        return  nTextProperties;      
    }
    
    /**
    * Create child element {@odfLink number:text}.
    *
    *@return   return  the element {@odfLink number:text}
    */
    public OdfTextElement createTextElement()
    {
        OdfTextElement  nText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextElement.class);
        this.appendChild( nText);
        return  nText;
    }                   
               
    /**
    * Create child element {@odfLink number:day}.
    *
    *@return   return  the element {@odfLink number:day}
    */
    public OdfDayElement createDayElement()
    {
        OdfDayElement  nDay = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDayElement.class);
        this.appendChild( nDay);
        return  nDay;
    }                   
               
    /**
    * Create child element {@odfLink number:month}.
    *
    *@return   return  the element {@odfLink number:month}
    */
    public OdfMonthElement createMonthElement()
    {
        OdfMonthElement  nMonth = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMonthElement.class);
        this.appendChild( nMonth);
        return  nMonth;
    }                   
               
    /**
    * Create child element {@odfLink number:year}.
    *
    *@return   return  the element {@odfLink number:year}
    */
    public OdfYearElement createYearElement()
    {
        OdfYearElement  nYear = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfYearElement.class);
        this.appendChild( nYear);
        return  nYear;
    }                   
               
    /**
    * Create child element {@odfLink number:era}.
    *
    *@return   return  the element {@odfLink number:era}
    */
    public OdfEraElement createEraElement()
    {
        OdfEraElement  nEra = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEraElement.class);
        this.appendChild( nEra);
        return  nEra;
    }                   
               
    /**
    * Create child element {@odfLink number:day-of-week}.
    *
    *@return   return  the element {@odfLink number:day-of-week}
    */
    public OdfDayOfWeekElement createDayOfWeekElement()
    {
        OdfDayOfWeekElement  nDayOfWeek = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDayOfWeekElement.class);
        this.appendChild( nDayOfWeek);
        return  nDayOfWeek;
    }                   
               
    /**
    * Create child element {@odfLink number:week-of-year}.
    *
    *@return   return  the element {@odfLink number:week-of-year}
    */
    public OdfWeekOfYearElement createWeekOfYearElement()
    {
        OdfWeekOfYearElement  nWeekOfYear = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfWeekOfYearElement.class);
        this.appendChild( nWeekOfYear);
        return  nWeekOfYear;
    }                   
               
    /**
    * Create child element {@odfLink number:quarter}.
    *
    *@return   return  the element {@odfLink number:quarter}
    */
    public OdfQuarterElement createQuarterElement()
    {
        OdfQuarterElement  nQuarter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfQuarterElement.class);
        this.appendChild( nQuarter);
        return  nQuarter;
    }                   
               
    /**
    * Create child element {@odfLink number:hours}.
    *
    *@return   return  the element {@odfLink number:hours}
    */
    public OdfHoursElement createHoursElement()
    {
        OdfHoursElement  nHours = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHoursElement.class);
        this.appendChild( nHours);
        return  nHours;
    }                   
               
    /**
    * Create child element {@odfLink number:am-pm}.
    *
    *@return   return  the element {@odfLink number:am-pm}
    */
    public OdfAmPmElement createAmPmElement()
    {
        OdfAmPmElement  nAmPm = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAmPmElement.class);
        this.appendChild( nAmPm);
        return  nAmPm;
    }                   
               
    /**
    * Create child element {@odfLink number:minutes}.
    *
    *@return   return  the element {@odfLink number:minutes}
    */
    public OdfMinutesElement createMinutesElement()
    {
        OdfMinutesElement  nMinutes = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMinutesElement.class);
        this.appendChild( nMinutes);
        return  nMinutes;
    }                   
               
    /**
    * Create child element {@odfLink number:seconds}.
    *
    *@return   return  the element {@odfLink number:seconds}
    */
    public OdfSecondsElement createSecondsElement()
    {
        OdfSecondsElement  nSeconds = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSecondsElement.class);
        this.appendChild( nSeconds);
        return  nSeconds;
    }                   
               
    /**
    * Create child element {@odfLink style:map}.
    *
    *@param condition String   
    *@param applyStyleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink style:map}
    */
    public OdfMapElement createMapElement(String   condition, org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   applyStyleName)
    {
        OdfMapElement  nMap = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMapElement.class);
        nMap.setCondition( condition);
        nMap.setApplyStyleName( applyStyleName);
        this.appendChild( nMap);
        return  nMap;      
    }
    
}
