/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.number;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink number:currency-symbol}.
 *
 */
public abstract class OdfCurrencySymbolElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.NUMBER, "currency-symbol" );

    /**
     * Create the instance of OdfCurrencySymbolElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfCurrencySymbolElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink number:currency-symbol}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName number:language}.
     *
     *@return return the attribute which type is String
     */
    public String getLanguage()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "language" ) );
    }

    /**
     * Set value of attribute {@attributeName number:language}.
     *
     *@param  language    the attribute's type is String
     */ 
     public void setLanguage( String language )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "language" ), language );
    }

    /**
     * Get value of attribute {@attributeName number:country}.
     *
     *@return return the attribute which type is String
     */
    public String getCountry()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "country" ) );
    }

    /**
     * Set value of attribute {@attributeName number:country}.
     *
     *@param  country    the attribute's type is String
     */ 
     public void setCountry( String country )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "country" ), country );
    }

    /**
     * Get value of attribute {@attributeName number:script}.
     *
     *@return return the attribute which type is String
     */
    public String getScript()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "script" ) );
    }

    /**
     * Set value of attribute {@attributeName number:script}.
     *
     *@param  script    the attribute's type is String
     */ 
     public void setScript( String script )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "script" ), script );
    }

    /**
     * Get value of attribute {@attributeName number:rfc-language-tag}.
     *
     *@return return the attribute which type is String
     */
    public String getRfcLanguageTag()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "rfc-language-tag" ) );
    }

    /**
     * Set value of attribute {@attributeName number:rfc-language-tag}.
     *
     *@param  rfcLanguageTag    the attribute's type is String
     */ 
     public void setRfcLanguageTag( String rfcLanguageTag )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "rfc-language-tag" ), rfcLanguageTag );
    }

}
