/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.number;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.number.OdfTransliterationStyleType;

import org.odftoolkit.odfdom.dom.element.style.OdfTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfMapElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink number:boolean-style}.
 *
 */
public abstract class OdfBooleanStyleElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.NUMBER, "boolean-style" );

    /**
     * Create the instance of OdfBooleanStyleElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfBooleanStyleElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink number:boolean-style}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfBooleanStyleElement}
     *
     *@param name  The mandatory attribute {@attributeName  style:name}" 
     *
     */
    public void init(OdfStyleName name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName style:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName number:language}.
     *
     *@return return the attribute which type is String
     */
    public String getLanguage()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "language" ) );
    }

    /**
     * Set value of attribute {@attributeName number:language}.
     *
     *@param  language    the attribute's type is String
     */ 
     public void setLanguage( String language )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "language" ), language );
    }

    /**
     * Get value of attribute {@attributeName number:country}.
     *
     *@return return the attribute which type is String
     */
    public String getCountry()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "country" ) );
    }

    /**
     * Set value of attribute {@attributeName number:country}.
     *
     *@param  country    the attribute's type is String
     */ 
     public void setCountry( String country )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "country" ), country );
    }

    /**
     * Get value of attribute {@attributeName number:script}.
     *
     *@return return the attribute which type is String
     */
    public String getScript()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "script" ) );
    }

    /**
     * Set value of attribute {@attributeName number:script}.
     *
     *@param  script    the attribute's type is String
     */ 
     public void setScript( String script )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "script" ), script );
    }

    /**
     * Get value of attribute {@attributeName number:rfc-language-tag}.
     *
     *@return return the attribute which type is String
     */
    public String getRfcLanguageTag()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "rfc-language-tag" ) );
    }

    /**
     * Set value of attribute {@attributeName number:rfc-language-tag}.
     *
     *@param  rfcLanguageTag    the attribute's type is String
     */ 
     public void setRfcLanguageTag( String rfcLanguageTag )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "rfc-language-tag" ), rfcLanguageTag );
    }

    /**
     * Get value of attribute {@attributeName number:title}.
     *
     *@return return the attribute which type is String
     */
    public String getTitle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "title" ) );
    }

    /**
     * Set value of attribute {@attributeName number:title}.
     *
     *@param  title    the attribute's type is String
     */ 
     public void setTitle( String title )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "title" ), title );
    }

    /**
     * Get value of attribute {@attributeName style:volatile}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getVolatile()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "volatile" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:volatile}.
     *
     *@param  isVolatile    the attribute's type is OdfBoolean
     */ 
     public void setVolatile( OdfBoolean isVolatile )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "volatile" ), isVolatile.toString() );
    }

    /**
     * Get value of attribute {@attributeName number:transliteration-format}.
     *
     *@return return the attribute which type is String
     */
    public String getTransliterationFormat()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-format" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "1";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName number:transliteration-format}.
     *
     *@param  transliterationFormat    the attribute's type is String
     */ 
     public void setTransliterationFormat( String transliterationFormat )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-format" ), transliterationFormat );
    }

    /**
     * Get value of attribute {@attributeName number:transliteration-language}.
     *
     *@return return the attribute which type is String
     */
    public String getTransliterationLanguage()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-language" ) );
    }

    /**
     * Set value of attribute {@attributeName number:transliteration-language}.
     *
     *@param  transliterationLanguage    the attribute's type is String
     */ 
     public void setTransliterationLanguage( String transliterationLanguage )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-language" ), transliterationLanguage );
    }

    /**
     * Get value of attribute {@attributeName number:transliteration-country}.
     *
     *@return return the attribute which type is String
     */
    public String getTransliterationCountry()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-country" ) );
    }

    /**
     * Set value of attribute {@attributeName number:transliteration-country}.
     *
     *@param  transliterationCountry    the attribute's type is String
     */ 
     public void setTransliterationCountry( String transliterationCountry )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-country" ), transliterationCountry );
    }

    /**
     * Get value of attribute {@attributeName number:transliteration-style}.
     *
     *@return return the attribute which type is OdfTransliterationStyleType
     */
    public OdfTransliterationStyleType getTransliterationStyle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-style" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "short";
        }

        return OdfTransliterationStyleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName number:transliteration-style}.
     *
     *@param  transliterationStyle    the attribute's type is OdfTransliterationStyleType
     */ 
     public void setTransliterationStyle( OdfTransliterationStyleType transliterationStyle )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.NUMBER, "transliteration-style" ), transliterationStyle.toString() );
    }

    /**
    * Create child element {@odfLink style:text-properties}.
    *
    *@param display String   
    *@return   return  the element {@odfLink style:text-properties}
    */
    public OdfTextPropertiesElement createTextPropertiesElement(String   display)
    {
        OdfTextPropertiesElement  nTextProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextPropertiesElement.class);
        this.appendChild( nTextProperties);
        return  nTextProperties;      
    }
    
    /**
    * Create child element {@odfLink style:text-properties}.
    *
    *@param display String   
    *@param condition String   
    *@return   return  the element {@odfLink style:text-properties}
    */
    public OdfTextPropertiesElement createTextPropertiesElement(String   display, String   condition)
    {
        OdfTextPropertiesElement  nTextProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextPropertiesElement.class);
        this.appendChild( nTextProperties);
        return  nTextProperties;      
    }
    
    /**
    * Create child element {@odfLink number:text}.
    *
    *@return   return  the element {@odfLink number:text}
    */
    public OdfTextElement createTextElement()
    {
        OdfTextElement  nText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextElement.class);
        this.appendChild( nText);
        return  nText;
    }                   
               
    /**
    * Create child element {@odfLink number:boolean}.
    *
    *@return   return  the element {@odfLink number:boolean}
    */
    public OdfBooleanElement createBooleanElement()
    {
        OdfBooleanElement  nBoolean = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBooleanElement.class);
        this.appendChild( nBoolean);
        return  nBoolean;
    }                   
               
    /**
    * Create child element {@odfLink style:map}.
    *
    *@param condition String   
    *@param applyStyleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink style:map}
    */
    public OdfMapElement createMapElement(String   condition, org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   applyStyleName)
    {
        OdfMapElement  nMap = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMapElement.class);
        nMap.setCondition( condition);
        nMap.setApplyStyleName( applyStyleName);
        this.appendChild( nMap);
        return  nMap;      
    }
    
}
