/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.meta;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.office.OdfTargetFrameNameType;
import org.odftoolkit.odfdom.dom.type.xlink.OdfShowType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink meta:hyperlink-behaviour}.
 *
 */
public abstract class OdfHyperlinkBehaviourElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.META, "hyperlink-behaviour" );

    /**
     * Create the instance of OdfHyperlinkBehaviourElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfHyperlinkBehaviourElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink meta:hyperlink-behaviour}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName office:target-frame-name}.
     *
     *@return return the attribute which type is OdfTargetFrameNameType
     */
    public OdfTargetFrameNameType getTargetFrameName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "target-frame-name" ) );
        return OdfTargetFrameNameType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:target-frame-name}.
     *
     *@param  targetFrameName    the attribute's type is OdfTargetFrameNameType
     */ 
     public void setTargetFrameName( OdfTargetFrameNameType targetFrameName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "target-frame-name" ), targetFrameName.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:show}.
     *
     *@return return the attribute which type is OdfShowType
     */
    public OdfShowType getShow()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ) );
        return OdfShowType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:show}.
     *
     *@param  show    the attribute's type is OdfShowType
     */ 
     public void setShow( OdfShowType show )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ), show.toString() );
    }

}
