/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.meta;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink meta:document-statistic}.
 *
 */
public abstract class OdfDocumentStatisticElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.META, "document-statistic" );

    /**
     * Create the instance of OdfDocumentStatisticElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDocumentStatisticElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink meta:document-statistic}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName meta:page-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getPageCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "page-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:page-count}.
     *
     *@param  pageCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setPageCount( OdfNonNegativeInteger pageCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "page-count" ), pageCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:table-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getTableCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "table-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:table-count}.
     *
     *@param  tableCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setTableCount( OdfNonNegativeInteger tableCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "table-count" ), tableCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:draw-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getDrawCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "draw-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:draw-count}.
     *
     *@param  drawCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setDrawCount( OdfNonNegativeInteger drawCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "draw-count" ), drawCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:image-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getImageCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "image-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:image-count}.
     *
     *@param  imageCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setImageCount( OdfNonNegativeInteger imageCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "image-count" ), imageCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:ole-object-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getOleObjectCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "ole-object-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:ole-object-count}.
     *
     *@param  oleObjectCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setOleObjectCount( OdfNonNegativeInteger oleObjectCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "ole-object-count" ), oleObjectCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:object-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getObjectCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "object-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:object-count}.
     *
     *@param  objectCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setObjectCount( OdfNonNegativeInteger objectCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "object-count" ), objectCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:paragraph-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getParagraphCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "paragraph-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:paragraph-count}.
     *
     *@param  paragraphCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setParagraphCount( OdfNonNegativeInteger paragraphCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "paragraph-count" ), paragraphCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:word-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getWordCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "word-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:word-count}.
     *
     *@param  wordCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setWordCount( OdfNonNegativeInteger wordCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "word-count" ), wordCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:character-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getCharacterCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "character-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:character-count}.
     *
     *@param  characterCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setCharacterCount( OdfNonNegativeInteger characterCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "character-count" ), characterCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:frame-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getFrameCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "frame-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:frame-count}.
     *
     *@param  frameCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setFrameCount( OdfNonNegativeInteger frameCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "frame-count" ), frameCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:sentence-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getSentenceCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "sentence-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:sentence-count}.
     *
     *@param  sentenceCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setSentenceCount( OdfNonNegativeInteger sentenceCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "sentence-count" ), sentenceCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:syllable-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getSyllableCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "syllable-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:syllable-count}.
     *
     *@param  syllableCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setSyllableCount( OdfNonNegativeInteger syllableCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "syllable-count" ), syllableCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:non-whitespace-character-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getNonWhitespaceCharacterCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "non-whitespace-character-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:non-whitespace-character-count}.
     *
     *@param  nonWhitespaceCharacterCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setNonWhitespaceCharacterCount( OdfNonNegativeInteger nonWhitespaceCharacterCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "non-whitespace-character-count" ), nonWhitespaceCharacterCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:row-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getRowCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "row-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:row-count}.
     *
     *@param  rowCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setRowCount( OdfNonNegativeInteger rowCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "row-count" ), rowCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName meta:cell-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getCellCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.META, "cell-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName meta:cell-count}.
     *
     *@param  cellCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setCellCount( OdfNonNegativeInteger cellCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.META, "cell-count" ), cellCount.toString() );
    }

}
