/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.form;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfId;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.OdfCellAddress;

import org.odftoolkit.odfdom.dom.element.office.OdfEventListenersElement;
import org.odftoolkit.odfdom.dom.element.text.OdfParagraphElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink form:textarea}.
 *
 */
public abstract class OdfTextareaElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.FORM, "textarea" );

    /**
     * Create the instance of OdfTextareaElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTextareaElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink form:textarea}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfTextareaElement}
     *
     *@param id  The mandatory attribute {@attributeName  form:id}" 
     *@param xmlid  The mandatory attribute {@attributeName  xml:xmlid}" 
     *
     */
    public void init(String id, OdfId xmlid)
    {
        setId( id );
        setXmlid( xmlid );
    }

    /**
     * Get value of attribute {@attributeName form:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName form:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName form:control-implementation}.
     *
     *@return return the attribute which type is String
     */
    public String getControlImplementation()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "control-implementation" ) );
    }

    /**
     * Set value of attribute {@attributeName form:control-implementation}.
     *
     *@param  controlImplementation    the attribute's type is String
     */ 
     public void setControlImplementation( String controlImplementation )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "control-implementation" ), controlImplementation );
    }

    /**
     * Get value of attribute {@attributeName form:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName form:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName xforms:bind}.
     *
     *@return return the attribute which type is String
     */
    public String getBind()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XFORMS, "bind" ) );
    }

    /**
     * Set value of attribute {@attributeName xforms:bind}.
     *
     *@param  bind    the attribute's type is String
     */ 
     public void setBind( String bind )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XFORMS, "bind" ), bind );
    }

    /**
     * Get value of attribute {@attributeName form:current-value}.
     *
     *@return return the attribute which type is String
     */
    public String getCurrentValue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "current-value" ) );
    }

    /**
     * Set value of attribute {@attributeName form:current-value}.
     *
     *@param  currentValue    the attribute's type is String
     */ 
     public void setCurrentValue( String currentValue )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "current-value" ), currentValue );
    }

    /**
     * Get value of attribute {@attributeName form:disabled}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getDisabled()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "disabled" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:disabled}.
     *
     *@param  isDisabled    the attribute's type is OdfBoolean
     */ 
     public void setDisabled( OdfBoolean isDisabled )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "disabled" ), isDisabled.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:max-length}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getMaxLength()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "max-length" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:max-length}.
     *
     *@param  maxLength    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setMaxLength( OdfNonNegativeInteger maxLength )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "max-length" ), maxLength.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:printable}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getPrintable()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "printable" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:printable}.
     *
     *@param  isPrintable    the attribute's type is OdfBoolean
     */ 
     public void setPrintable( OdfBoolean isPrintable )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "printable" ), isPrintable.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:readonly}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getReadonly()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "readonly" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:readonly}.
     *
     *@param  isReadonly    the attribute's type is OdfBoolean
     */ 
     public void setReadonly( OdfBoolean isReadonly )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "readonly" ), isReadonly.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:tab-index}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getTabIndex()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "tab-index" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0";
        }

        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:tab-index}.
     *
     *@param  tabIndex    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setTabIndex( OdfNonNegativeInteger tabIndex )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "tab-index" ), tabIndex.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:tab-stop}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getTabStop()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "tab-stop" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:tab-stop}.
     *
     *@param  isTabStop    the attribute's type is OdfBoolean
     */ 
     public void setTabStop( OdfBoolean isTabStop )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "tab-stop" ), isTabStop.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:title}.
     *
     *@return return the attribute which type is String
     */
    public String getTitle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "title" ) );
    }

    /**
     * Set value of attribute {@attributeName form:title}.
     *
     *@param  title    the attribute's type is String
     */ 
     public void setTitle( String title )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "title" ), title );
    }

    /**
     * Get value of attribute {@attributeName form:value}.
     *
     *@return return the attribute which type is String
     */
    public String getValue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "value" ) );
    }

    /**
     * Set value of attribute {@attributeName form:value}.
     *
     *@param  value    the attribute's type is String
     */ 
     public void setValue( String value )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "value" ), value );
    }

    /**
     * Get value of attribute {@attributeName form:convert-empty-to-null}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getConvertEmptyToNull()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "convert-empty-to-null" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:convert-empty-to-null}.
     *
     *@param  isConvertEmptyToNull    the attribute's type is OdfBoolean
     */ 
     public void setConvertEmptyToNull( OdfBoolean isConvertEmptyToNull )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "convert-empty-to-null" ), isConvertEmptyToNull.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:data-field}.
     *
     *@return return the attribute which type is String
     */
    public String getDataField()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "data-field" ) );
    }

    /**
     * Set value of attribute {@attributeName form:data-field}.
     *
     *@param  dataField    the attribute's type is String
     */ 
     public void setDataField( String dataField )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "data-field" ), dataField );
    }

    /**
     * Get value of attribute {@attributeName form:linked-cell}.
     *
     *@return return the attribute which type is OdfCellAddress
     */
    public OdfCellAddress getLinkedCell()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "linked-cell" ) );
        return OdfCellAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:linked-cell}.
     *
     *@param  linkedCell    the attribute's type is OdfCellAddress
     */ 
     public void setLinkedCell( OdfCellAddress linkedCell )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "linked-cell" ), linkedCell.toString() );
    }

    /**
    * Create child element {@odfLink form:properties}.
    *
    *@return   return  the element {@odfLink form:properties}
    */
    public OdfPropertiesElement createPropertiesElement()
    {
        OdfPropertiesElement  nProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPropertiesElement.class);
        this.appendChild( nProperties);
        return  nProperties;
    }                   
               
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
    /**
    * Create child element {@odfLink text:p}.
    *
    *@return   return  the element {@odfLink text:p}
    */
    public OdfParagraphElement createParagraphElement()
    {
        OdfParagraphElement  nParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParagraphElement.class);
        this.appendChild( nParagraph);
        return  nParagraph;
    }                   
               
}
