/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.form;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import org.odftoolkit.odfdom.dom.type.office.OdfValueMaybeVoidType;
import org.odftoolkit.odfdom.dom.type.office.OdfValueMaybeVoidType;

/**
 * DOM implementation of OpenDocument element  {@odfLink form:properties}.
 *
 */
public abstract class OdfPropertiesElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.FORM, "properties" );

    /**
     * Create the instance of OdfPropertiesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfPropertiesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink form:properties}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink form:property}.
    *
    *@param propertyName String   
    *@param valueType   the attribute's type is OdfValueMaybeVoidType, see {@attributeName  office:value-maybe-void} at specification
    *@return   return  the element {@odfLink form:property}
    */
    public OdfPropertyElement createPropertyElement(String   propertyName, OdfValueMaybeVoidType   valueType)
    {
        OdfPropertyElement  nProperty = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPropertyElement.class);
        nProperty.setPropertyName( propertyName);
        nProperty.setValueType( valueType);
        this.appendChild( nProperty);
        return  nProperty;      
    }
    
    /**
    * Create child element {@odfLink form:list-property}.
    *
    *@param propertyName String   
    *@param valueType   the attribute's type is OdfValueMaybeVoidType, see {@attributeName  office:value-maybe-void} at specification
    *@return   return  the element {@odfLink form:list-property}
    */
    public OdfListPropertyElement createListPropertyElement(String   propertyName, OdfValueMaybeVoidType   valueType)
    {
        OdfListPropertyElement  nListProperty = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListPropertyElement.class);
        nListProperty.setPropertyName( propertyName);
        nListProperty.setValueType( valueType);
        this.appendChild( nListProperty);
        return  nListProperty;      
    }
    
}
