/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.form;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink form:option}.
 *
 */
public abstract class OdfOptionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.FORM, "option" );

    /**
     * Create the instance of OdfOptionElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfOptionElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink form:option}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName form:current-selected}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCurrentSelected()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "current-selected" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:current-selected}.
     *
     *@param  isCurrentSelected    the attribute's type is OdfBoolean
     */ 
     public void setCurrentSelected( OdfBoolean isCurrentSelected )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "current-selected" ), isCurrentSelected.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:selected}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getSelected()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "selected" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:selected}.
     *
     *@param  isSelected    the attribute's type is OdfBoolean
     */ 
     public void setSelected( OdfBoolean isSelected )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "selected" ), isSelected.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:label}.
     *
     *@return return the attribute which type is String
     */
    public String getLabel()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "label" ) );
    }

    /**
     * Set value of attribute {@attributeName form:label}.
     *
     *@param  label    the attribute's type is String
     */ 
     public void setLabel( String label )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "label" ), label );
    }

    /**
     * Get value of attribute {@attributeName form:value}.
     *
     *@return return the attribute which type is String
     */
    public String getValue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "value" ) );
    }

    /**
     * Set value of attribute {@attributeName form:value}.
     *
     *@param  value    the attribute's type is String
     */ 
     public void setValue( String value )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "value" ), value );
    }

}
