/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.form;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.office.OdfValueMaybeVoidType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink form:list-property}.
 *
 */
public abstract class OdfListPropertyElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.FORM, "list-property" );

    /**
     * Create the instance of OdfListPropertyElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfListPropertyElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink form:list-property}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfListPropertyElement}
     *
     *@param propertyName  The mandatory attribute {@attributeName  form:property-name}" 
     *@param valueType  The mandatory attribute {@attributeName  office:value-type}" 
     *
     */
    public void init(String propertyName, OdfValueMaybeVoidType valueType)
    {
        setPropertyName( propertyName );
        setValueType( valueType );
    }

    /**
     * Get value of attribute {@attributeName form:property-name}.
     *
     *@return return the attribute which type is String
     */
    public String getPropertyName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "property-name" ) );
    }

    /**
     * Set value of attribute {@attributeName form:property-name}.
     *
     *@param  propertyName    the attribute's type is String
     */ 
     public void setPropertyName( String propertyName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "property-name" ), propertyName );
    }

    /**
     * Get value of attribute {@attributeName office:value-type}.
     *
     *@return return the attribute which type is OdfValueMaybeVoidType
     */
    public OdfValueMaybeVoidType getValueType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value-type" ) );
        return OdfValueMaybeVoidType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:value-type}.
     *
     *@param  valueType    the attribute's type is OdfValueMaybeVoidType
     */ 
     public void setValueType( OdfValueMaybeVoidType valueType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value-type" ), valueType.toString() );
    }

}
