/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.form;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfId;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;

import org.odftoolkit.odfdom.dom.element.office.OdfEventListenersElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink form:image-frame}.
 *
 */
public abstract class OdfImageFrameElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.FORM, "image-frame" );

    /**
     * Create the instance of OdfImageFrameElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfImageFrameElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink form:image-frame}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfImageFrameElement}
     *
     *@param id  The mandatory attribute {@attributeName  form:id}" 
     *@param xmlid  The mandatory attribute {@attributeName  xml:xmlid}" 
     *
     */
    public void init(String id, OdfId xmlid)
    {
        setId( id );
        setXmlid( xmlid );
    }

    /**
     * Get value of attribute {@attributeName form:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName form:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName form:control-implementation}.
     *
     *@return return the attribute which type is String
     */
    public String getControlImplementation()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "control-implementation" ) );
    }

    /**
     * Set value of attribute {@attributeName form:control-implementation}.
     *
     *@param  controlImplementation    the attribute's type is String
     */ 
     public void setControlImplementation( String controlImplementation )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "control-implementation" ), controlImplementation );
    }

    /**
     * Get value of attribute {@attributeName form:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName form:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName xforms:bind}.
     *
     *@return return the attribute which type is String
     */
    public String getBind()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XFORMS, "bind" ) );
    }

    /**
     * Set value of attribute {@attributeName xforms:bind}.
     *
     *@param  bind    the attribute's type is String
     */ 
     public void setBind( String bind )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XFORMS, "bind" ), bind );
    }

    /**
     * Get value of attribute {@attributeName form:disabled}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getDisabled()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "disabled" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:disabled}.
     *
     *@param  isDisabled    the attribute's type is OdfBoolean
     */ 
     public void setDisabled( OdfBoolean isDisabled )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "disabled" ), isDisabled.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:image-data}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getImageData()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "image-data" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:image-data}.
     *
     *@param  imageData    the attribute's type is OdfAnyURI
     */ 
     public void setImageData( OdfAnyURI imageData )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "image-data" ), imageData.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:printable}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getPrintable()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "printable" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:printable}.
     *
     *@param  isPrintable    the attribute's type is OdfBoolean
     */ 
     public void setPrintable( OdfBoolean isPrintable )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "printable" ), isPrintable.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:readonly}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getReadonly()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "readonly" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:readonly}.
     *
     *@param  isReadonly    the attribute's type is OdfBoolean
     */ 
     public void setReadonly( OdfBoolean isReadonly )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "readonly" ), isReadonly.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:title}.
     *
     *@return return the attribute which type is String
     */
    public String getTitle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "title" ) );
    }

    /**
     * Set value of attribute {@attributeName form:title}.
     *
     *@param  title    the attribute's type is String
     */ 
     public void setTitle( String title )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "title" ), title );
    }

    /**
     * Get value of attribute {@attributeName form:data-field}.
     *
     *@return return the attribute which type is String
     */
    public String getDataField()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "data-field" ) );
    }

    /**
     * Set value of attribute {@attributeName form:data-field}.
     *
     *@param  dataField    the attribute's type is String
     */ 
     public void setDataField( String dataField )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "data-field" ), dataField );
    }

    /**
    * Create child element {@odfLink form:properties}.
    *
    *@return   return  the element {@odfLink form:properties}
    */
    public OdfPropertiesElement createPropertiesElement()
    {
        OdfPropertiesElement  nProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPropertiesElement.class);
        this.appendChild( nProperties);
        return  nProperties;
    }                   
               
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
}
