/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.form;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.office.OdfTargetFrameNameType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.form.OdfCommandType;
import org.odftoolkit.odfdom.dom.type.form.OdfNavigationModeType;
import org.odftoolkit.odfdom.dom.type.form.OdfTabCycleType;

import org.odftoolkit.odfdom.dom.element.office.OdfEventListenersElement;
import org.odftoolkit.odfdom.dom.type.form.OdfImagePositionType;
import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink form:form}.
 *
 */
public abstract class OdfFormElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.FORM, "form" );

    /**
     * Create the instance of OdfFormElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfFormElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink form:form}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName form:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName form:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName form:control-implementation}.
     *
     *@return return the attribute which type is String
     */
    public String getControlImplementation()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "control-implementation" ) );
    }

    /**
     * Set value of attribute {@attributeName form:control-implementation}.
     *
     *@param  controlImplementation    the attribute's type is String
     */ 
     public void setControlImplementation( String controlImplementation )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "control-implementation" ), controlImplementation );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "actuate" ), "onRequest" );
    }

    /**
     * Get value of attribute {@attributeName office:target-frame}.
     *
     *@return return the attribute which type is OdfTargetFrameNameType
     */
    public OdfTargetFrameNameType getTargetFrame()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "target-frame" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "_blank";
        }

        return OdfTargetFrameNameType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:target-frame}.
     *
     *@param  targetFrame    the attribute's type is OdfTargetFrameNameType
     */ 
     public void setTargetFrame( OdfTargetFrameNameType targetFrame )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "target-frame" ), targetFrame.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:method}.
     *
     *@return return the attribute which type is String
     */
    public String getMethod()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "method" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "get";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:method}.
     *
     *@param  method    the attribute's type is String
     */ 
     public void setMethod( String method )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "method" ), method );
    }

    /**
     * Get value of attribute {@attributeName form:enctype}.
     *
     *@return return the attribute which type is String
     */
    public String getEnctype()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "enctype" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "application/x-www-form-urlencoded";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:enctype}.
     *
     *@param  enctype    the attribute's type is String
     */ 
     public void setEnctype( String enctype )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "enctype" ), enctype );
    }

    /**
     * Get value of attribute {@attributeName form:allow-deletes}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAllowDeletes()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "allow-deletes" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:allow-deletes}.
     *
     *@param  isAllowDeletes    the attribute's type is OdfBoolean
     */ 
     public void setAllowDeletes( OdfBoolean isAllowDeletes )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "allow-deletes" ), isAllowDeletes.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:allow-inserts}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAllowInserts()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "allow-inserts" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:allow-inserts}.
     *
     *@param  isAllowInserts    the attribute's type is OdfBoolean
     */ 
     public void setAllowInserts( OdfBoolean isAllowInserts )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "allow-inserts" ), isAllowInserts.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:allow-updates}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAllowUpdates()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "allow-updates" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:allow-updates}.
     *
     *@param  isAllowUpdates    the attribute's type is OdfBoolean
     */ 
     public void setAllowUpdates( OdfBoolean isAllowUpdates )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "allow-updates" ), isAllowUpdates.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:apply-filter}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getApplyFilter()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "apply-filter" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:apply-filter}.
     *
     *@param  isApplyFilter    the attribute's type is OdfBoolean
     */ 
     public void setApplyFilter( OdfBoolean isApplyFilter )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "apply-filter" ), isApplyFilter.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:command-type}.
     *
     *@return return the attribute which type is OdfCommandType
     */
    public OdfCommandType getCommandType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "command-type" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "command";
        }

        return OdfCommandType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:command-type}.
     *
     *@param  commandType    the attribute's type is OdfCommandType
     */ 
     public void setCommandType( OdfCommandType commandType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "command-type" ), commandType.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:command}.
     *
     *@return return the attribute which type is String
     */
    public String getCommand()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "command" ) );
    }

    /**
     * Set value of attribute {@attributeName form:command}.
     *
     *@param  command    the attribute's type is String
     */ 
     public void setCommand( String command )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "command" ), command );
    }

    /**
     * Get value of attribute {@attributeName form:datasource}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getDatasource()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "datasource" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:datasource}.
     *
     *@param  datasource    the attribute's type is OdfAnyURI
     */ 
     public void setDatasource( OdfAnyURI datasource )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "datasource" ), datasource.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:master-fields}.
     *
     *@return return the attribute which type is String
     */
    public String getMasterFields()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "master-fields" ) );
    }

    /**
     * Set value of attribute {@attributeName form:master-fields}.
     *
     *@param  masterFields    the attribute's type is String
     */ 
     public void setMasterFields( String masterFields )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "master-fields" ), masterFields );
    }

    /**
     * Get value of attribute {@attributeName form:detail-fields}.
     *
     *@return return the attribute which type is String
     */
    public String getDetailFields()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "detail-fields" ) );
    }

    /**
     * Set value of attribute {@attributeName form:detail-fields}.
     *
     *@param  detailFields    the attribute's type is String
     */ 
     public void setDetailFields( String detailFields )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "detail-fields" ), detailFields );
    }

    /**
     * Get value of attribute {@attributeName form:escape-processing}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getEscapeProcessing()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "escape-processing" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:escape-processing}.
     *
     *@param  isEscapeProcessing    the attribute's type is OdfBoolean
     */ 
     public void setEscapeProcessing( OdfBoolean isEscapeProcessing )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "escape-processing" ), isEscapeProcessing.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:filter}.
     *
     *@return return the attribute which type is String
     */
    public String getFilter()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "filter" ) );
    }

    /**
     * Set value of attribute {@attributeName form:filter}.
     *
     *@param  filter    the attribute's type is String
     */ 
     public void setFilter( String filter )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "filter" ), filter );
    }

    /**
     * Get value of attribute {@attributeName form:ignore-result}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIgnoreResult()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "ignore-result" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:ignore-result}.
     *
     *@param  isIgnoreResult    the attribute's type is OdfBoolean
     */ 
     public void setIgnoreResult( OdfBoolean isIgnoreResult )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "ignore-result" ), isIgnoreResult.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:navigation-mode}.
     *
     *@return return the attribute which type is OdfNavigationModeType
     */
    public OdfNavigationModeType getNavigationMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "navigation-mode" ) );
        return OdfNavigationModeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:navigation-mode}.
     *
     *@param  navigationMode    the attribute's type is OdfNavigationModeType
     */ 
     public void setNavigationMode( OdfNavigationModeType navigationMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "navigation-mode" ), navigationMode.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:order}.
     *
     *@return return the attribute which type is String
     */
    public String getOrder()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "order" ) );
    }

    /**
     * Set value of attribute {@attributeName form:order}.
     *
     *@param  order    the attribute's type is String
     */ 
     public void setOrder( String order )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "order" ), order );
    }

    /**
     * Get value of attribute {@attributeName form:tab-cycle}.
     *
     *@return return the attribute which type is OdfTabCycleType
     */
    public OdfTabCycleType getTabCycle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "tab-cycle" ) );
        return OdfTabCycleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:tab-cycle}.
     *
     *@param  tabCycle    the attribute's type is OdfTabCycleType
     */ 
     public void setTabCycle( OdfTabCycleType tabCycle )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "tab-cycle" ), tabCycle.toString() );
    }

    /**
    * Create child element {@odfLink form:properties}.
    *
    *@return   return  the element {@odfLink form:properties}
    */
    public OdfPropertiesElement createPropertiesElement()
    {
        OdfPropertiesElement  nProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPropertiesElement.class);
        this.appendChild( nProperties);
        return  nProperties;
    }                   
               
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
    /**
    * Create child element {@odfLink form:text}.
    *
    *@return   return  the element {@odfLink form:text}
    */
    public OdfTextElement createTextElement()
    {
        OdfTextElement  nText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextElement.class);
        this.appendChild( nText);
        return  nText;
    }                   
               
    /**
    * Create child element {@odfLink form:textarea}.
    *
    *@return   return  the element {@odfLink form:textarea}
    */
    public OdfTextareaElement createTextareaElement()
    {
        OdfTextareaElement  nTextarea = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextareaElement.class);
        this.appendChild( nTextarea);
        return  nTextarea;
    }                   
               
    /**
    * Create child element {@odfLink form:formatted-text}.
    *
    *@return   return  the element {@odfLink form:formatted-text}
    */
    public OdfFormattedTextElement createFormattedTextElement()
    {
        OdfFormattedTextElement  nFormattedText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFormattedTextElement.class);
        this.appendChild( nFormattedText);
        return  nFormattedText;
    }                   
               
    /**
    * Create child element {@odfLink form:number}.
    *
    *@return   return  the element {@odfLink form:number}
    */
    public OdfNumberElement createNumberElement()
    {
        OdfNumberElement  nNumber = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNumberElement.class);
        this.appendChild( nNumber);
        return  nNumber;
    }                   
               
    /**
    * Create child element {@odfLink form:date}.
    *
    *@return   return  the element {@odfLink form:date}
    */
    public OdfDateElement createDateElement()
    {
        OdfDateElement  nDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDateElement.class);
        this.appendChild( nDate);
        return  nDate;
    }                   
               
    /**
    * Create child element {@odfLink form:time}.
    *
    *@return   return  the element {@odfLink form:time}
    */
    public OdfTimeElement createTimeElement()
    {
        OdfTimeElement  nTime = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTimeElement.class);
        this.appendChild( nTime);
        return  nTime;
    }                   
               
    /**
    * Create child element {@odfLink form:combobox}.
    *
    *@return   return  the element {@odfLink form:combobox}
    */
    public OdfComboboxElement createComboboxElement()
    {
        OdfComboboxElement  nCombobox = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfComboboxElement.class);
        this.appendChild( nCombobox);
        return  nCombobox;
    }                   
               
    /**
    * Create child element {@odfLink form:listbox}.
    *
    *@return   return  the element {@odfLink form:listbox}
    */
    public OdfListboxElement createListboxElement()
    {
        OdfListboxElement  nListbox = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListboxElement.class);
        this.appendChild( nListbox);
        return  nListbox;
    }                   
               
    /**
    * Create child element {@odfLink form:checkbox}.
    *
    
    *@return   return  the element {@odfLink form:checkbox}
    */
    public OdfCheckboxElement createCheckboxElement()
    {
        OdfCheckboxElement  nCheckbox = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCheckboxElement.class);
        this.appendChild( nCheckbox);
        return  nCheckbox;      
    }
    
    /**
    * Create child element {@odfLink form:checkbox}.
    *
    *@param imagePosition     the attribute's type is OdfImagePositionType, see {@attributeName  form:image-position} at specification
    *@return   return  the element {@odfLink form:checkbox}
    */
    public OdfCheckboxElement createCheckboxElement(OdfImagePositionType   imagePosition)
    {
        OdfCheckboxElement  nCheckbox = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCheckboxElement.class);
        nCheckbox.setImagePosition( imagePosition);
        this.appendChild( nCheckbox);
        return  nCheckbox;      
    }
    
    /**
    * Create child element {@odfLink form:password}.
    *
    *@return   return  the element {@odfLink form:password}
    */
    public OdfPasswordElement createPasswordElement()
    {
        OdfPasswordElement  nPassword = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPasswordElement.class);
        this.appendChild( nPassword);
        return  nPassword;
    }                   
               
    /**
    * Create child element {@odfLink form:file}.
    *
    *@return   return  the element {@odfLink form:file}
    */
    public OdfFileElement createFileElement()
    {
        OdfFileElement  nFile = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFileElement.class);
        this.appendChild( nFile);
        return  nFile;
    }                   
               
    /**
    * Create child element {@odfLink form:fixed-text}.
    *
    *@return   return  the element {@odfLink form:fixed-text}
    */
    public OdfFixedTextElement createFixedTextElement()
    {
        OdfFixedTextElement  nFixedText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFixedTextElement.class);
        this.appendChild( nFixedText);
        return  nFixedText;
    }                   
               
    /**
    * Create child element {@odfLink form:button}.
    *
    
    *@return   return  the element {@odfLink form:button}
    */
    public OdfButtonElement createButtonElement()
    {
        OdfButtonElement  nButton = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfButtonElement.class);
        this.appendChild( nButton);
        return  nButton;      
    }
    
    /**
    * Create child element {@odfLink form:button}.
    *
    *@param imagePosition     the attribute's type is OdfImagePositionType, see {@attributeName  form:image-position} at specification
    *@return   return  the element {@odfLink form:button}
    */
    public OdfButtonElement createButtonElement(OdfImagePositionType   imagePosition)
    {
        OdfButtonElement  nButton = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfButtonElement.class);
        nButton.setImagePosition( imagePosition);
        this.appendChild( nButton);
        return  nButton;      
    }
    
    /**
    * Create child element {@odfLink form:image}.
    *
    *@return   return  the element {@odfLink form:image}
    */
    public OdfImageElement createImageElement()
    {
        OdfImageElement  nImage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfImageElement.class);
        this.appendChild( nImage);
        return  nImage;
    }                   
               
    /**
    * Create child element {@odfLink form:radio}.
    *
    
    *@return   return  the element {@odfLink form:radio}
    */
    public OdfRadioElement createRadioElement()
    {
        OdfRadioElement  nRadio = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRadioElement.class);
        this.appendChild( nRadio);
        return  nRadio;      
    }
    
    /**
    * Create child element {@odfLink form:radio}.
    *
    *@param imagePosition     the attribute's type is OdfImagePositionType, see {@attributeName  form:image-position} at specification
    *@return   return  the element {@odfLink form:radio}
    */
    public OdfRadioElement createRadioElement(OdfImagePositionType   imagePosition)
    {
        OdfRadioElement  nRadio = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRadioElement.class);
        nRadio.setImagePosition( imagePosition);
        this.appendChild( nRadio);
        return  nRadio;      
    }
    
    /**
    * Create child element {@odfLink form:frame}.
    *
    *@return   return  the element {@odfLink form:frame}
    */
    public OdfFrameElement createFrameElement()
    {
        OdfFrameElement  nFrame = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFrameElement.class);
        this.appendChild( nFrame);
        return  nFrame;
    }                   
               
    /**
    * Create child element {@odfLink form:image-frame}.
    *
    *@return   return  the element {@odfLink form:image-frame}
    */
    public OdfImageFrameElement createImageFrameElement()
    {
        OdfImageFrameElement  nImageFrame = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfImageFrameElement.class);
        this.appendChild( nImageFrame);
        return  nImageFrame;
    }                   
               
    /**
    * Create child element {@odfLink form:hidden}.
    *
    *@return   return  the element {@odfLink form:hidden}
    */
    public OdfHiddenElement createHiddenElement()
    {
        OdfHiddenElement  nHidden = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHiddenElement.class);
        this.appendChild( nHidden);
        return  nHidden;
    }                   
               
    /**
    * Create child element {@odfLink form:grid}.
    *
    *@return   return  the element {@odfLink form:grid}
    */
    public OdfGridElement createGridElement()
    {
        OdfGridElement  nGrid = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGridElement.class);
        this.appendChild( nGrid);
        return  nGrid;
    }                   
               
    /**
    * Create child element {@odfLink form:value-range}.
    *
    *@return   return  the element {@odfLink form:value-range}
    */
    public OdfValueRangeElement createValueRangeElement()
    {
        OdfValueRangeElement  nValueRange = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfValueRangeElement.class);
        this.appendChild( nValueRange);
        return  nValueRange;
    }                   
               
    /**
    * Create child element {@odfLink form:generic-control}.
    *
    *@return   return  the element {@odfLink form:generic-control}
    */
    public OdfGenericControlElement createGenericControlElement()
    {
        OdfGenericControlElement  nGenericControl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGenericControlElement.class);
        this.appendChild( nGenericControl);
        return  nGenericControl;
    }                   
               
    /**
    * Create child element {@odfLink form:form}.
    *
    *@return   return  the element {@odfLink form:form}
    */
    public OdfFormElement createFormElement()
    {
        OdfFormElement  nForm = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFormElement.class);
        this.appendChild( nForm);
        return  nForm;
    }                   
               
    /**
    * Create child element {@odfLink form:connection-resource}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink form:connection-resource}
    */
    public OdfConnectionResourceElement createConnectionResourceElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfConnectionResourceElement  nConnectionResource = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConnectionResourceElement.class);
        nConnectionResource.setHref( href);
        this.appendChild( nConnectionResource);
        return  nConnectionResource;      
    }
    
}
