/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.form;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

import org.odftoolkit.odfdom.dom.type.form.OdfImagePositionType;

/**
 * DOM implementation of OpenDocument element  {@odfLink form:column}.
 *
 */
public abstract class OdfColumnElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.FORM, "column" );

    /**
     * Create the instance of OdfColumnElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfColumnElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink form:column}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName form:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName form:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName form:control-implementation}.
     *
     *@return return the attribute which type is String
     */
    public String getControlImplementation()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "control-implementation" ) );
    }

    /**
     * Set value of attribute {@attributeName form:control-implementation}.
     *
     *@param  controlImplementation    the attribute's type is String
     */ 
     public void setControlImplementation( String controlImplementation )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "control-implementation" ), controlImplementation );
    }

    /**
     * Get value of attribute {@attributeName form:label}.
     *
     *@return return the attribute which type is String
     */
    public String getLabel()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "label" ) );
    }

    /**
     * Set value of attribute {@attributeName form:label}.
     *
     *@param  label    the attribute's type is String
     */ 
     public void setLabel( String label )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "label" ), label );
    }

    /**
     * Get value of attribute {@attributeName form:text-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getTextStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "text-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:text-style-name}.
     *
     *@param  textStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setTextStyleName( OdfStyleNameRef textStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "text-style-name" ), textStyleName.toString() );
    }

    /**
    * Create child element {@odfLink form:text}.
    *
    *@return   return  the element {@odfLink form:text}
    */
    public OdfTextElement createTextElement()
    {
        OdfTextElement  nText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextElement.class);
        this.appendChild( nText);
        return  nText;
    }                   
               
    /**
    * Create child element {@odfLink form:textarea}.
    *
    *@return   return  the element {@odfLink form:textarea}
    */
    public OdfTextareaElement createTextareaElement()
    {
        OdfTextareaElement  nTextarea = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextareaElement.class);
        this.appendChild( nTextarea);
        return  nTextarea;
    }                   
               
    /**
    * Create child element {@odfLink form:formatted-text}.
    *
    *@return   return  the element {@odfLink form:formatted-text}
    */
    public OdfFormattedTextElement createFormattedTextElement()
    {
        OdfFormattedTextElement  nFormattedText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFormattedTextElement.class);
        this.appendChild( nFormattedText);
        return  nFormattedText;
    }                   
               
    /**
    * Create child element {@odfLink form:number}.
    *
    *@return   return  the element {@odfLink form:number}
    */
    public OdfNumberElement createNumberElement()
    {
        OdfNumberElement  nNumber = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNumberElement.class);
        this.appendChild( nNumber);
        return  nNumber;
    }                   
               
    /**
    * Create child element {@odfLink form:date}.
    *
    *@return   return  the element {@odfLink form:date}
    */
    public OdfDateElement createDateElement()
    {
        OdfDateElement  nDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDateElement.class);
        this.appendChild( nDate);
        return  nDate;
    }                   
               
    /**
    * Create child element {@odfLink form:time}.
    *
    *@return   return  the element {@odfLink form:time}
    */
    public OdfTimeElement createTimeElement()
    {
        OdfTimeElement  nTime = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTimeElement.class);
        this.appendChild( nTime);
        return  nTime;
    }                   
               
    /**
    * Create child element {@odfLink form:combobox}.
    *
    *@return   return  the element {@odfLink form:combobox}
    */
    public OdfComboboxElement createComboboxElement()
    {
        OdfComboboxElement  nCombobox = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfComboboxElement.class);
        this.appendChild( nCombobox);
        return  nCombobox;
    }                   
               
    /**
    * Create child element {@odfLink form:listbox}.
    *
    *@return   return  the element {@odfLink form:listbox}
    */
    public OdfListboxElement createListboxElement()
    {
        OdfListboxElement  nListbox = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListboxElement.class);
        this.appendChild( nListbox);
        return  nListbox;
    }                   
               
    /**
    * Create child element {@odfLink form:checkbox}.
    *
    
    *@return   return  the element {@odfLink form:checkbox}
    */
    public OdfCheckboxElement createCheckboxElement()
    {
        OdfCheckboxElement  nCheckbox = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCheckboxElement.class);
        this.appendChild( nCheckbox);
        return  nCheckbox;      
    }
    
    /**
    * Create child element {@odfLink form:checkbox}.
    *
    *@param imagePosition     the attribute's type is OdfImagePositionType, see {@attributeName  form:image-position} at specification
    *@return   return  the element {@odfLink form:checkbox}
    */
    public OdfCheckboxElement createCheckboxElement(OdfImagePositionType   imagePosition)
    {
        OdfCheckboxElement  nCheckbox = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCheckboxElement.class);
        nCheckbox.setImagePosition( imagePosition);
        this.appendChild( nCheckbox);
        return  nCheckbox;      
    }
    
}
