/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.form;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfId;
import org.odftoolkit.odfdom.dom.type.form.OdfButtonType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.office.OdfTargetFrameNameType;
import org.odftoolkit.odfdom.dom.type.form.OdfImagePositionType;
import org.odftoolkit.odfdom.dom.type.form.OdfImageAlignType;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.type.OdfDuration;

import org.odftoolkit.odfdom.dom.element.office.OdfEventListenersElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink form:button}.
 *
 */
public abstract class OdfButtonElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.FORM, "button" );

    /**
     * Create the instance of OdfButtonElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfButtonElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink form:button}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfButtonElement}
     *
     *@param id  The mandatory attribute {@attributeName  form:id}" 
     *@param xmlid  The mandatory attribute {@attributeName  xml:xmlid}" 
     *
     */
    public void init(String id, OdfId xmlid)
    {
        setId( id );
        setXmlid( xmlid );
    }

    /**
     * Get value of attribute {@attributeName form:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName form:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName form:control-implementation}.
     *
     *@return return the attribute which type is String
     */
    public String getControlImplementation()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "control-implementation" ) );
    }

    /**
     * Set value of attribute {@attributeName form:control-implementation}.
     *
     *@param  controlImplementation    the attribute's type is String
     */ 
     public void setControlImplementation( String controlImplementation )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "control-implementation" ), controlImplementation );
    }

    /**
     * Get value of attribute {@attributeName form:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName form:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName xforms:bind}.
     *
     *@return return the attribute which type is String
     */
    public String getBind()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XFORMS, "bind" ) );
    }

    /**
     * Set value of attribute {@attributeName xforms:bind}.
     *
     *@param  bind    the attribute's type is String
     */ 
     public void setBind( String bind )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XFORMS, "bind" ), bind );
    }

    /**
     * Get value of attribute {@attributeName form:button-type}.
     *
     *@return return the attribute which type is OdfButtonType
     */
    public OdfButtonType getButtonType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "button-type" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "push";
        }

        return OdfButtonType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:button-type}.
     *
     *@param  buttonType    the attribute's type is OdfButtonType
     */ 
     public void setButtonType( OdfButtonType buttonType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "button-type" ), buttonType.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:disabled}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getDisabled()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "disabled" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:disabled}.
     *
     *@param  isDisabled    the attribute's type is OdfBoolean
     */ 
     public void setDisabled( OdfBoolean isDisabled )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "disabled" ), isDisabled.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:label}.
     *
     *@return return the attribute which type is String
     */
    public String getLabel()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "label" ) );
    }

    /**
     * Set value of attribute {@attributeName form:label}.
     *
     *@param  label    the attribute's type is String
     */ 
     public void setLabel( String label )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "label" ), label );
    }

    /**
     * Get value of attribute {@attributeName form:image-data}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getImageData()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "image-data" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:image-data}.
     *
     *@param  imageData    the attribute's type is OdfAnyURI
     */ 
     public void setImageData( OdfAnyURI imageData )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "image-data" ), imageData.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:printable}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getPrintable()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "printable" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:printable}.
     *
     *@param  isPrintable    the attribute's type is OdfBoolean
     */ 
     public void setPrintable( OdfBoolean isPrintable )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "printable" ), isPrintable.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:tab-index}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getTabIndex()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "tab-index" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0";
        }

        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:tab-index}.
     *
     *@param  tabIndex    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setTabIndex( OdfNonNegativeInteger tabIndex )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "tab-index" ), tabIndex.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:tab-stop}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getTabStop()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "tab-stop" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:tab-stop}.
     *
     *@param  isTabStop    the attribute's type is OdfBoolean
     */ 
     public void setTabStop( OdfBoolean isTabStop )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "tab-stop" ), isTabStop.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:target-frame}.
     *
     *@return return the attribute which type is OdfTargetFrameNameType
     */
    public OdfTargetFrameNameType getTargetFrame()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "target-frame" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "_blank";
        }

        return OdfTargetFrameNameType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:target-frame}.
     *
     *@param  targetFrame    the attribute's type is OdfTargetFrameNameType
     */ 
     public void setTargetFrame( OdfTargetFrameNameType targetFrame )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "target-frame" ), targetFrame.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:title}.
     *
     *@return return the attribute which type is String
     */
    public String getTitle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "title" ) );
    }

    /**
     * Set value of attribute {@attributeName form:title}.
     *
     *@param  title    the attribute's type is String
     */ 
     public void setTitle( String title )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "title" ), title );
    }

    /**
     * Get value of attribute {@attributeName form:value}.
     *
     *@return return the attribute which type is String
     */
    public String getValue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "value" ) );
    }

    /**
     * Set value of attribute {@attributeName form:value}.
     *
     *@param  value    the attribute's type is String
     */ 
     public void setValue( String value )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "value" ), value );
    }

    /**
     * Get value of attribute {@attributeName form:image-position}.
     *
     *@return return the attribute which type is OdfImagePositionType
     */
    public OdfImagePositionType getImagePosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "image-position" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "center";
        }

        return OdfImagePositionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:image-position}.
     *
     *@param  imagePosition    the attribute's type is OdfImagePositionType
     */ 
     public void setImagePosition( OdfImagePositionType imagePosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "image-position" ), imagePosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:image-align}.
     *
     *@return return the attribute which type is OdfImageAlignType
     */
    public OdfImageAlignType getImageAlign()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "image-align" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "center";
        }

        return OdfImageAlignType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:image-align}.
     *
     *@param  imageAlign    the attribute's type is OdfImageAlignType
     */ 
     public void setImageAlign( OdfImageAlignType imageAlign )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "image-align" ), imageAlign.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:repeat}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getRepeat()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "repeat" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:repeat}.
     *
     *@param  isRepeat    the attribute's type is OdfBoolean
     */ 
     public void setRepeat( OdfBoolean isRepeat )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "repeat" ), isRepeat.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:delay-for-repeat}.
     *
     *@return return the attribute which type is OdfDuration
     */
    public OdfDuration getDelayForRepeat()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "delay-for-repeat" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "PT0.050S";
        }

        return OdfDuration.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:delay-for-repeat}.
     *
     *@param  delayForRepeat    the attribute's type is OdfDuration
     */ 
     public void setDelayForRepeat( OdfDuration delayForRepeat )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "delay-for-repeat" ), delayForRepeat.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:default-button}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getDefaultButton()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "default-button" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:default-button}.
     *
     *@param  isDefaultButton    the attribute's type is OdfBoolean
     */ 
     public void setDefaultButton( OdfBoolean isDefaultButton )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "default-button" ), isDefaultButton.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:toggle}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getToggle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "toggle" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:toggle}.
     *
     *@param  isToggle    the attribute's type is OdfBoolean
     */ 
     public void setToggle( OdfBoolean isToggle )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "toggle" ), isToggle.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:focus-on-click}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getFocusOnClick()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FORM, "focus-on-click" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName form:focus-on-click}.
     *
     *@param  isFocusOnClick    the attribute's type is OdfBoolean
     */ 
     public void setFocusOnClick( OdfBoolean isFocusOnClick )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "focus-on-click" ), isFocusOnClick.toString() );
    }

    /**
     * Get value of attribute {@attributeName form:xforms-submission}.
     *
     *@return return the attribute which type is String
     */
    public String getXformsSubmission()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FORM, "xforms-submission" ) );
    }

    /**
     * Set value of attribute {@attributeName form:xforms-submission}.
     *
     *@param  xformsSubmission    the attribute's type is String
     */ 
     public void setXformsSubmission( String xformsSubmission )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FORM, "xforms-submission" ), xformsSubmission );
    }

    /**
    * Create child element {@odfLink form:properties}.
    *
    *@return   return  the element {@odfLink form:properties}
    */
    public OdfPropertiesElement createPropertiesElement()
    {
        OdfPropertiesElement  nProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPropertiesElement.class);
        this.appendChild( nProperties);
        return  nProperties;
    }                   
               
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
}
