/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.odftoolkit.odfdom.dom.type.draw.OdfStrokeStyleType;
import org.odftoolkit.odfdom.dom.type.OdfLength;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:stroke-dash}.
 *
 */
public abstract class OdfStrokeDashElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "stroke-dash" );

    /**
     * Create the instance of OdfStrokeDashElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfStrokeDashElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:stroke-dash}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfStrokeDashElement}
     *
     *@param name  The mandatory attribute {@attributeName  draw:name}" 
     *
     */
    public void init(OdfStyleName name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName draw:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:display-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDisplayName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display-name" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:display-name}.
     *
     *@param  displayName    the attribute's type is String
     */ 
     public void setDisplayName( String displayName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display-name" ), displayName );
    }

    /**
     * Get value of attribute {@attributeName draw:style}.
     *
     *@return return the attribute which type is OdfStrokeStyleType
     */
    public OdfStrokeStyleType getStyle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style" ) );
        return OdfStrokeStyleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:style}.
     *
     *@param  style    the attribute's type is OdfStrokeStyleType
     */ 
     public void setStyle( OdfStrokeStyleType style )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style" ), style.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:dots1}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getDots1()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "dots1" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:dots1}.
     *
     *@param  dots1    the attribute's type is Integer
     */ 
     public void setDots1( Integer dots1 )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "dots1" ), dots1.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:dots1-length}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getDots1Length()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "dots1-length" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:dots1-length}.
     *
     *@param  dots1Length    the attribute's type is OdfLength
     */ 
     public void setDots1Length( OdfLength dots1Length )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "dots1-length" ), dots1Length.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:dots2}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getDots2()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "dots2" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:dots2}.
     *
     *@param  dots2    the attribute's type is Integer
     */ 
     public void setDots2( Integer dots2 )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "dots2" ), dots2.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:dots2-length}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getDots2Length()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "dots2-length" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:dots2-length}.
     *
     *@param  dots2Length    the attribute's type is OdfLength
     */ 
     public void setDots2Length( OdfLength dots2Length )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "dots2-length" ), dots2Length.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:distance}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getDistance()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "distance" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:distance}.
     *
     *@param  distance    the attribute's type is OdfLength
     */ 
     public void setDistance( OdfLength distance )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "distance" ), distance.toString() );
    }

}
