/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    
package org.odftoolkit.odfdom.dom.element.draw;
import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStyleablePresentationElement;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.OdfId;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import java.util.List;
import org.odftoolkit.odfdom.dom.type.OdfStyleNames;
import org.odftoolkit.odfdom.dom.type.OdfCellAddress;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.text.OdfAnchorType;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;


/**
 * DOM implementation of OpenDocument base element 
 */
public abstract class OdfShapeElementBase extends OdfStyleablePresentationElement
{
    /**
     * Create the instance of OdfShapeElementBase 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     *@param  element_name   The type is OdfName
     */
    public OdfShapeElementBase( OdfFileDom aOwnerDoc, OdfName element_name )
    {
        super( aOwnerDoc, element_name );
    }
    /**
     * Initialization of the mandatory attributes of {@link  OdfShapeElementBase}
     *
     
    *
     */
    public void init()
    {
    }
      
    /**
     * Get value of attribute {@attributeName draw:z-index}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getZIndex()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "z-index" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:z-index}.
     *
     *@param  zIndex    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setZIndex( OdfNonNegativeInteger zIndex )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "z-index" ), zIndex.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:id}.
     *
     *@return return the attribute which type is String
     */
    public String getDrawid()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:id}.
     *
     *@param  drawid    the attribute's type is String
     */ 
     public void setDrawid( String drawid )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "id" ), drawid );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDrawStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:style-name}.
     *
     *@param  drawStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDrawStyleName( OdfStyleNameRef drawStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style-name" ), drawStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:class-names}.
     *
     *@return return the attribute which type is List<String>
     */
    public List<String> getDrawClassNames()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "class-names" ) );
        return OdfStyleNames.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:class-names}.
     *
     *@param  drawClassNames    the attribute's type is OdfStyleNames
     */ 
     public void setDrawClassNames( OdfStyleNames drawClassNames )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "class-names" ), drawClassNames.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getPresentationStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:style-name}.
     *
     *@param  presentationStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setPresentationStyleName( OdfStyleNameRef presentationStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "style-name" ), presentationStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:class-names}.
     *
     *@return return the attribute which type is List<String>
     */
    public List<String> getPresentationClassNames()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "class-names" ) );
        return OdfStyleNames.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:class-names}.
     *
     *@param  presentationClassNames    the attribute's type is OdfStyleNames
     */ 
     public void setPresentationClassNames( OdfStyleNames presentationClassNames )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "class-names" ), presentationClassNames.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName table:end-cell-address}.
     *
     *@return return the attribute which type is OdfCellAddress
     */
    public OdfCellAddress getEndCellAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-cell-address" ) );
        return OdfCellAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:end-cell-address}.
     *
     *@param  endCellAddress    the attribute's type is OdfCellAddress
     */ 
     public void setEndCellAddress( OdfCellAddress endCellAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-cell-address" ), endCellAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:end-x}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getEndX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-x" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:end-x}.
     *
     *@param  endX    the attribute's type is OdfLength
     */ 
     public void setEndX( OdfLength endX )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-x" ), endX.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:end-y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getEndY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:end-y}.
     *
     *@param  endY    the attribute's type is OdfLength
     */ 
     public void setEndY( OdfLength endY )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-y" ), endY.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:table-background}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getTableBackground()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "table-background" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:table-background}.
     *
     *@param  isTableBackground    the attribute's type is OdfBoolean
     */ 
     public void setTableBackground( OdfBoolean isTableBackground )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "table-background" ), isTableBackground.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:anchor-type}.
     *
     *@return return the attribute which type is OdfAnchorType
     */
    public OdfAnchorType getAnchorType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "anchor-type" ) );
        return OdfAnchorType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:anchor-type}.
     *
     *@param  anchorType    the attribute's type is OdfAnchorType
     */ 
     public void setAnchorType( OdfAnchorType anchorType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "anchor-type" ), anchorType.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:anchor-page-number}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getAnchorPageNumber()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "anchor-page-number" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:anchor-page-number}.
     *
     *@param  anchorPageNumber    the attribute's type is OdfPositiveInteger
     */ 
     public void setAnchorPageNumber( OdfPositiveInteger anchorPageNumber )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "anchor-page-number" ), anchorPageNumber.toString() );
    }

}
      