/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.OdfPresentationClasses;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfId;

import org.odftoolkit.odfdom.dom.element.svg.OdfTitleElement;
import org.odftoolkit.odfdom.dom.element.svg.OdfDescElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:page-thumbnail}.
 *
 */
public abstract class OdfPageThumbnailElement extends OdfShapeElementBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "page-thumbnail" );

    /**
     * Create the instance of OdfPageThumbnailElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfPageThumbnailElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:page-thumbnail}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName draw:page-number}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getPageNumber()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "page-number" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:page-number}.
     *
     *@param  pageNumber    the attribute's type is OdfPositiveInteger
     */ 
     public void setPageNumber( OdfPositiveInteger pageNumber )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "page-number" ), pageNumber.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:x}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x}.
     *
     *@param  x    the attribute's type is OdfLength
     */ 
     public void setX( OdfLength x )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ), x.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y}.
     *
     *@param  y    the attribute's type is OdfLength
     */ 
     public void setY( OdfLength y )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ), y.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:width}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:width}.
     *
     *@param  width    the attribute's type is OdfLength
     */ 
     public void setWidth( OdfLength width )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ), width.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:height}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:height}.
     *
     *@param  height    the attribute's type is OdfLength
     */ 
     public void setHeight( OdfLength height )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ), height.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:class}.
     *
     *@return return the attribute which type is OdfPresentationClasses
     */
    public OdfPresentationClasses getPresentationClass()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "class" ) );
        return OdfPresentationClasses.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:class}.
     *
     *@param  presentationClass    the attribute's type is OdfPresentationClasses
     */ 
     public void setPresentationClass( OdfPresentationClasses presentationClass )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "class" ), presentationClass.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:placeholder}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getPlaceholder()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "placeholder" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:placeholder}.
     *
     *@param  isPlaceholder    the attribute's type is OdfBoolean
     */ 
     public void setPlaceholder( OdfBoolean isPlaceholder )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "placeholder" ), isPlaceholder.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:user-transformed}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUserTransformed()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "user-transformed" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:user-transformed}.
     *
     *@param  isUserTransformed    the attribute's type is OdfBoolean
     */ 
     public void setUserTransformed( OdfBoolean isUserTransformed )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "user-transformed" ), isUserTransformed.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:layer}.
     *
     *@return return the attribute which type is String
     */
    public String getLayer()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "layer" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:layer}.
     *
     *@param  layer    the attribute's type is String
     */ 
     public void setLayer( String layer )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "layer" ), layer );
    }

    /**
     * Get value of attribute {@attributeName draw:transform}.
     *
     *@return return the attribute which type is String
     */
    public String getTransform()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "transform" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:transform}.
     *
     *@param  transform    the attribute's type is String
     */ 
     public void setTransform( String transform )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "transform" ), transform );
    }

    /**
     * Get value of attribute {@attributeName draw:caption-id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getCaptionId()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "caption-id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:caption-id}.
     *
     *@param  captionId    the attribute's type is OdfId
     */ 
     public void setCaptionId( OdfId captionId )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "caption-id" ), captionId.toString() );
    }

    /**
    * Create child element {@odfLink svg:title}.
    *
    *@return   return  the element {@odfLink svg:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink svg:desc}.
    *
    *@return   return  the element {@odfLink svg:desc}
    */
    public OdfDescElement createDescElement()
    {
        OdfDescElement  nDesc = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescElement.class);
        this.appendChild( nDesc);
        return  nDesc;
    }                   
               
}
