/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.odftoolkit.odfdom.dom.type.draw.OdfGradientStyleType;
import org.odftoolkit.odfdom.dom.type.OdfPercent;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:opacity}.
 *
 */
public abstract class OdfOpacityElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "opacity" );

    /**
     * Create the instance of OdfOpacityElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfOpacityElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:opacity}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfOpacityElement}
     *
     *@param style  The mandatory attribute {@attributeName  draw:style}" 
     *
     */
    public void init(OdfGradientStyleType style)
    {
        setStyle( style );
    }

    /**
     * Get value of attribute {@attributeName draw:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:display-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDisplayName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display-name" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:display-name}.
     *
     *@param  displayName    the attribute's type is String
     */ 
     public void setDisplayName( String displayName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display-name" ), displayName );
    }

    /**
     * Get value of attribute {@attributeName draw:style}.
     *
     *@return return the attribute which type is OdfGradientStyleType
     */
    public OdfGradientStyleType getStyle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style" ) );
        return OdfGradientStyleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:style}.
     *
     *@param  style    the attribute's type is OdfGradientStyleType
     */ 
     public void setStyle( OdfGradientStyleType style )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style" ), style.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:cx}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getCx()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "cx" ) );
        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:cx}.
     *
     *@param  cx    the attribute's type is OdfPercent
     */ 
     public void setCx( OdfPercent cx )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "cx" ), cx.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:cy}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getCy()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "cy" ) );
        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:cy}.
     *
     *@param  cy    the attribute's type is OdfPercent
     */ 
     public void setCy( OdfPercent cy )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "cy" ), cy.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:angle}.
     *
     *@return return the attribute which type is String
     */
    public String getAngle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "angle" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:angle}.
     *
     *@param  angle    the attribute's type is String
     */ 
     public void setAngle( String angle )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "angle" ), angle );
    }

    /**
     * Get value of attribute {@attributeName draw:border}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getBorder()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "border" ) );
        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:border}.
     *
     *@param  border    the attribute's type is OdfPercent
     */ 
     public void setBorder( OdfPercent border )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "border" ), border.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:start}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getStart()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "start" ) );
        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:start}.
     *
     *@param  start    the attribute's type is OdfPercent
     */ 
     public void setStart( OdfPercent start )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "start" ), start.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:end}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getEnd()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "end" ) );
        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:end}.
     *
     *@param  end    the attribute's type is OdfPercent
     */ 
     public void setEnd( OdfPercent end )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "end" ), end.toString() );
    }

}
