/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfId;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;

import org.odftoolkit.odfdom.dom.element.office.OdfDocumentElement;
import org.odftoolkit.odfdom.dom.element.math.OdfMathElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:object}.
 *
 */
public abstract class OdfObjectElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "object" );

    /**
     * Create the instance of OdfObjectElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfObjectElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:object}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfObjectElement}
     *
     *@param href  The mandatory attribute {@attributeName  xlink:href}" 
     *
     */
    public void init(OdfAnyURI href)
    {
        setHref( href );
    }

    /**
     * Get value of attribute {@attributeName draw:notify-on-update-of-ranges}.
     *
     *@return return the attribute which type is String
     */
    public String getNotifyOnUpdateOfRanges()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "notify-on-update-of-ranges" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:notify-on-update-of-ranges}.
     *
     *@param  notifyOnUpdateOfRanges    the attribute's type is String
     */ 
     public void setNotifyOnUpdateOfRanges( String notifyOnUpdateOfRanges )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "notify-on-update-of-ranges" ), notifyOnUpdateOfRanges );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ), "embed" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "actuate" ), "onLoad" );
    }

    /**
    * Create child element {@odfLink office:document}.
    *
    *@param mimetype String   
    *@param version String   
    *@return   return  the element {@odfLink office:document}
    */
    public OdfDocumentElement createDocumentElement(String   mimetype, String   version)
    {
        OdfDocumentElement  nDocument = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDocumentElement.class);
        nDocument.setMimetype( mimetype);
        nDocument.setVersion( version);
        this.appendChild( nDocument);
        return  nDocument;      
    }
    
    /**
    * Create child element {@odfLink math:math}.
    *
    
    *@return   return  the element {@odfLink math:math}
    */
    public OdfMathElement createMathElement()
    {
        OdfMathElement  nMath = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMathElement.class);
        this.appendChild( nMath);
        return  nMath;      
    }
    
}
