/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.draw.OdfDisplayType;

import org.odftoolkit.odfdom.dom.element.svg.OdfTitleElement;
import org.odftoolkit.odfdom.dom.element.svg.OdfDescElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:layer}.
 *
 */
public abstract class OdfLayerElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "layer" );

    /**
     * Create the instance of OdfLayerElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfLayerElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:layer}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfLayerElement}
     *
     *@param name  The mandatory attribute {@attributeName  draw:name}" 
     *
     */
    public void init(String name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName draw:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName draw:protected}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getProtected()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "protected" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:protected}.
     *
     *@param  isProtected    the attribute's type is OdfBoolean
     */ 
     public void setProtected( OdfBoolean isProtected )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "protected" ), isProtected.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:display}.
     *
     *@return return the attribute which type is OdfDisplayType
     */
    public OdfDisplayType getDisplay()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "always";
        }

        return OdfDisplayType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:display}.
     *
     *@param  display    the attribute's type is OdfDisplayType
     */ 
     public void setDisplay( OdfDisplayType display )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display" ), display.toString() );
    }

    /**
    * Create child element {@odfLink svg:title}.
    *
    *@return   return  the element {@odfLink svg:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink svg:desc}.
    *
    *@return   return  the element {@odfLink svg:desc}
    */
    public OdfDescElement createDescElement()
    {
        OdfDescElement  nDesc = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescElement.class);
        this.appendChild( nDesc);
        return  nDesc;
    }                   
               
}
