/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:image-map}.
 *
 */
public abstract class OdfImageMapElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "image-map" );

    /**
     * Create the instance of OdfImageMapElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfImageMapElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:image-map}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink draw:area-rectangle}.
    *
    *@param x  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param width  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param height  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink draw:area-rectangle}
    */
    public OdfAreaRectangleElement createAreaRectangleElement(org.odftoolkit.odfdom.dom.type.OdfLength   x, org.odftoolkit.odfdom.dom.type.OdfLength   y, org.odftoolkit.odfdom.dom.type.OdfLength   width, org.odftoolkit.odfdom.dom.type.OdfLength   height)
    {
        OdfAreaRectangleElement  nAreaRectangle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAreaRectangleElement.class);
        nAreaRectangle.setX( x);
        nAreaRectangle.setY( y);
        nAreaRectangle.setWidth( width);
        nAreaRectangle.setHeight( height);
        this.appendChild( nAreaRectangle);
        return  nAreaRectangle;      
    }
    
    /**
    * Create child element {@odfLink draw:area-circle}.
    *
    *@param cx  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param cy  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param r  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink draw:area-circle}
    */
    public OdfAreaCircleElement createAreaCircleElement(org.odftoolkit.odfdom.dom.type.OdfLength   cx, org.odftoolkit.odfdom.dom.type.OdfLength   cy, org.odftoolkit.odfdom.dom.type.OdfLength   r)
    {
        OdfAreaCircleElement  nAreaCircle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAreaCircleElement.class);
        nAreaCircle.setCx( cx);
        nAreaCircle.setCy( cy);
        nAreaCircle.setR( r);
        this.appendChild( nAreaCircle);
        return  nAreaCircle;      
    }
    
    /**
    * Create child element {@odfLink draw:area-polygon}.
    *
    *@param x  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param width  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param height  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param viewBox Integer   
    *@param points String   
    *@return   return  the element {@odfLink draw:area-polygon}
    */
    public OdfAreaPolygonElement createAreaPolygonElement(org.odftoolkit.odfdom.dom.type.OdfLength   x, org.odftoolkit.odfdom.dom.type.OdfLength   y, org.odftoolkit.odfdom.dom.type.OdfLength   width, org.odftoolkit.odfdom.dom.type.OdfLength   height, Integer   viewBox, String   points)
    {
        OdfAreaPolygonElement  nAreaPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAreaPolygonElement.class);
        nAreaPolygon.setX( x);
        nAreaPolygon.setY( y);
        nAreaPolygon.setWidth( width);
        nAreaPolygon.setHeight( height);
        nAreaPolygon.setViewBox( viewBox);
        nAreaPolygon.setPoints( points);
        this.appendChild( nAreaPolygon);
        return  nAreaPolygon;      
    }
    
}
