/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.odftoolkit.odfdom.dom.type.draw.OdfHatchStyleType;
import org.odftoolkit.odfdom.dom.type.OdfLength;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:hatch}.
 *
 */
public abstract class OdfHatchElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "hatch" );

    /**
     * Create the instance of OdfHatchElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfHatchElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:hatch}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfHatchElement}
     *
     *@param name  The mandatory attribute {@attributeName  draw:name}" 
     *@param style  The mandatory attribute {@attributeName  draw:style}" 
     *
     */
    public void init(OdfStyleName name, OdfHatchStyleType style)
    {
        setName( name );
        setStyle( style );
    }

    /**
     * Get value of attribute {@attributeName draw:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:display-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDisplayName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display-name" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:display-name}.
     *
     *@param  displayName    the attribute's type is String
     */ 
     public void setDisplayName( String displayName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display-name" ), displayName );
    }

    /**
     * Get value of attribute {@attributeName draw:style}.
     *
     *@return return the attribute which type is OdfHatchStyleType
     */
    public OdfHatchStyleType getStyle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style" ) );
        return OdfHatchStyleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:style}.
     *
     *@param  style    the attribute's type is OdfHatchStyleType
     */ 
     public void setStyle( OdfHatchStyleType style )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style" ), style.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:color}.
     *
     *@return return the attribute which type is String
     */
    public String getColor()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "color" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:color}.
     *
     *@param  color    the attribute's type is String
     */ 
     public void setColor( String color )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "color" ), color );
    }

    /**
     * Get value of attribute {@attributeName draw:distance}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getDistance()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "distance" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:distance}.
     *
     *@param  distance    the attribute's type is OdfLength
     */ 
     public void setDistance( OdfLength distance )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "distance" ), distance.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:rotation}.
     *
     *@return return the attribute which type is String
     */
    public String getRotation()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "rotation" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:rotation}.
     *
     *@param  rotation    the attribute's type is String
     */ 
     public void setRotation( String rotation )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "rotation" ), rotation );
    }

}
