/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:handle}.
 *
 */
public abstract class OdfHandleElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "handle" );

    /**
     * Create the instance of OdfHandleElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfHandleElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:handle}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfHandleElement}
     *
     *@param handlePosition  The mandatory attribute {@attributeName  draw:handle-position}" 
     *
     */
    public void init(String handlePosition)
    {
        setHandlePosition( handlePosition );
    }

    /**
     * Get value of attribute {@attributeName draw:handle-mirror-vertical}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getHandleMirrorVertical()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-mirror-vertical" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:handle-mirror-vertical}.
     *
     *@param  isHandleMirrorVertical    the attribute's type is OdfBoolean
     */ 
     public void setHandleMirrorVertical( OdfBoolean isHandleMirrorVertical )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-mirror-vertical" ), isHandleMirrorVertical.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:handle-mirror-horizontal}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getHandleMirrorHorizontal()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-mirror-horizontal" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:handle-mirror-horizontal}.
     *
     *@param  isHandleMirrorHorizontal    the attribute's type is OdfBoolean
     */ 
     public void setHandleMirrorHorizontal( OdfBoolean isHandleMirrorHorizontal )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-mirror-horizontal" ), isHandleMirrorHorizontal.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:handle-switched}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getHandleSwitched()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-switched" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:handle-switched}.
     *
     *@param  isHandleSwitched    the attribute's type is OdfBoolean
     */ 
     public void setHandleSwitched( OdfBoolean isHandleSwitched )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-switched" ), isHandleSwitched.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:handle-position}.
     *
     *@return return the attribute which type is String
     */
    public String getHandlePosition()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-position" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:handle-position}.
     *
     *@param  handlePosition    the attribute's type is String
     */ 
     public void setHandlePosition( String handlePosition )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-position" ), handlePosition );
    }

    /**
     * Get value of attribute {@attributeName draw:handle-range-x-minimum}.
     *
     *@return return the attribute which type is String
     */
    public String getHandleRangeXMinimum()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-range-x-minimum" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:handle-range-x-minimum}.
     *
     *@param  handleRangeXMinimum    the attribute's type is String
     */ 
     public void setHandleRangeXMinimum( String handleRangeXMinimum )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-range-x-minimum" ), handleRangeXMinimum );
    }

    /**
     * Get value of attribute {@attributeName draw:handle-range-x-maximum}.
     *
     *@return return the attribute which type is String
     */
    public String getHandleRangeXMaximum()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-range-x-maximum" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:handle-range-x-maximum}.
     *
     *@param  handleRangeXMaximum    the attribute's type is String
     */ 
     public void setHandleRangeXMaximum( String handleRangeXMaximum )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-range-x-maximum" ), handleRangeXMaximum );
    }

    /**
     * Get value of attribute {@attributeName draw:handle-range-y-minimum}.
     *
     *@return return the attribute which type is String
     */
    public String getHandleRangeYMinimum()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-range-y-minimum" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:handle-range-y-minimum}.
     *
     *@param  handleRangeYMinimum    the attribute's type is String
     */ 
     public void setHandleRangeYMinimum( String handleRangeYMinimum )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-range-y-minimum" ), handleRangeYMinimum );
    }

    /**
     * Get value of attribute {@attributeName draw:handle-range-y-maximum}.
     *
     *@return return the attribute which type is String
     */
    public String getHandleRangeYMaximum()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-range-y-maximum" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:handle-range-y-maximum}.
     *
     *@param  handleRangeYMaximum    the attribute's type is String
     */ 
     public void setHandleRangeYMaximum( String handleRangeYMaximum )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-range-y-maximum" ), handleRangeYMaximum );
    }

    /**
     * Get value of attribute {@attributeName draw:handle-polar}.
     *
     *@return return the attribute which type is String
     */
    public String getHandlePolar()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-polar" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:handle-polar}.
     *
     *@param  handlePolar    the attribute's type is String
     */ 
     public void setHandlePolar( String handlePolar )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-polar" ), handlePolar );
    }

    /**
     * Get value of attribute {@attributeName draw:handle-radius-range-minimum}.
     *
     *@return return the attribute which type is String
     */
    public String getHandleRadiusRangeMinimum()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-radius-range-minimum" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:handle-radius-range-minimum}.
     *
     *@param  handleRadiusRangeMinimum    the attribute's type is String
     */ 
     public void setHandleRadiusRangeMinimum( String handleRadiusRangeMinimum )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-radius-range-minimum" ), handleRadiusRangeMinimum );
    }

    /**
     * Get value of attribute {@attributeName draw:handle-radius-range-maximum}.
     *
     *@return return the attribute which type is String
     */
    public String getHandleRadiusRangeMaximum()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-radius-range-maximum" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:handle-radius-range-maximum}.
     *
     *@param  handleRadiusRangeMaximum    the attribute's type is String
     */ 
     public void setHandleRadiusRangeMaximum( String handleRadiusRangeMaximum )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "handle-radius-range-maximum" ), handleRadiusRangeMaximum );
    }

}
