/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.OdfId;

import org.odftoolkit.odfdom.dom.element.svg.OdfTitleElement;
import org.odftoolkit.odfdom.dom.element.svg.OdfDescElement;
import org.odftoolkit.odfdom.dom.element.office.OdfEventListenersElement;
import org.odftoolkit.odfdom.dom.type.draw.OdfEscapeDirectionType;
import org.odftoolkit.odfdom.dom.element.dr3d.OdfSceneElement;
import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:g}.
 *
 */
public abstract class OdfGroupElement extends OdfShapeElementBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "g" );

    /**
     * Create the instance of OdfGroupElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfGroupElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:g}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName svg:y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y}.
     *
     *@param  y    the attribute's type is OdfLength
     */ 
     public void setY( OdfLength y )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ), y.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:caption-id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getCaptionId()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "caption-id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:caption-id}.
     *
     *@param  captionId    the attribute's type is OdfId
     */ 
     public void setCaptionId( OdfId captionId )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "caption-id" ), captionId.toString() );
    }

    /**
    * Create child element {@odfLink svg:title}.
    *
    *@return   return  the element {@odfLink svg:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink svg:desc}.
    *
    *@return   return  the element {@odfLink svg:desc}
    */
    public OdfDescElement createDescElement()
    {
        OdfDescElement  nDesc = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescElement.class);
        this.appendChild( nDesc);
        return  nDesc;
    }                   
               
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
    /**
    * Create child element {@odfLink draw:glue-point}.
    *
    *@param drawid  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@param x  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param escapeDirection     the attribute's type is OdfEscapeDirectionType, see {@attributeName  draw:escape-direction} at specification
    *@return   return  the element {@odfLink draw:glue-point}
    */
    public OdfGluePointElement createGluePointElement(org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   drawid, org.odftoolkit.odfdom.dom.type.OdfLength   x, org.odftoolkit.odfdom.dom.type.OdfLength   y, OdfEscapeDirectionType   escapeDirection)
    {
        OdfGluePointElement  nGluePoint = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGluePointElement.class);
        nGluePoint.setDrawid( drawid);
        nGluePoint.setX( x);
        nGluePoint.setY( y);
        nGluePoint.setEscapeDirection( escapeDirection);
        this.appendChild( nGluePoint);
        return  nGluePoint;      
    }
    
    /**
    * Create child element {@odfLink draw:rect}.
    *
    *@return   return  the element {@odfLink draw:rect}
    */
    public OdfRectElement createRectElement()
    {
        OdfRectElement  nRect = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRectElement.class);
        this.appendChild( nRect);
        return  nRect;
    }                   
               
    /**
    * Create child element {@odfLink draw:line}.
    *
    *@param x1  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y1  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param x2  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y2  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink draw:line}
    */
    public OdfLineElement createLineElement(org.odftoolkit.odfdom.dom.type.OdfLength   x1, org.odftoolkit.odfdom.dom.type.OdfLength   y1, org.odftoolkit.odfdom.dom.type.OdfLength   x2, org.odftoolkit.odfdom.dom.type.OdfLength   y2)
    {
        OdfLineElement  nLine = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLineElement.class);
        nLine.setX1( x1);
        nLine.setY1( y1);
        nLine.setX2( x2);
        nLine.setY2( y2);
        this.appendChild( nLine);
        return  nLine;      
    }
    
    /**
    * Create child element {@odfLink draw:polyline}.
    *
    *@param points String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:polyline}
    */
    public OdfPolylineElement createPolylineElement(String   points, Integer   viewBox)
    {
        OdfPolylineElement  nPolyline = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPolylineElement.class);
        nPolyline.setPoints( points);
        nPolyline.setViewBox( viewBox);
        this.appendChild( nPolyline);
        return  nPolyline;      
    }
    
    /**
    * Create child element {@odfLink draw:polygon}.
    *
    *@param points String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:polygon}
    */
    public OdfPolygonElement createPolygonElement(String   points, Integer   viewBox)
    {
        OdfPolygonElement  nPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPolygonElement.class);
        nPolygon.setPoints( points);
        nPolygon.setViewBox( viewBox);
        this.appendChild( nPolygon);
        return  nPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:regular-polygon}.
    *
    *@param corners  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param concave   the attribute's type is Boolean
    *@return   return  the element {@odfLink draw:regular-polygon}
    */
    public OdfRegularPolygonElement createRegularPolygonElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   corners, org.odftoolkit.odfdom.dom.type.OdfBoolean   concave)
    {
        OdfRegularPolygonElement  nRegularPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegularPolygonElement.class);
        nRegularPolygon.setCorners( corners);
        nRegularPolygon.setConcave( concave);
        this.appendChild( nRegularPolygon);
        return  nRegularPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:regular-polygon}.
    *
    *@param concave   the attribute's type is Boolean
    *@param corners  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink draw:regular-polygon}
    */
    public OdfRegularPolygonElement createRegularPolygonElement(org.odftoolkit.odfdom.dom.type.OdfBoolean   concave, org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   corners)
    {
        OdfRegularPolygonElement  nRegularPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegularPolygonElement.class);
        nRegularPolygon.setConcave( concave);
        nRegularPolygon.setCorners( corners);
        this.appendChild( nRegularPolygon);
        return  nRegularPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:path}.
    *
    *@param d String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:path}
    */
    public OdfPathElement createPathElement(String   d, Integer   viewBox)
    {
        OdfPathElement  nPath = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPathElement.class);
        nPath.setD( d);
        nPath.setViewBox( viewBox);
        this.appendChild( nPath);
        return  nPath;      
    }
    
    /**
    * Create child element {@odfLink draw:circle}.
    *
    *@return   return  the element {@odfLink draw:circle}
    */
    public OdfCircleElement createCircleElement()
    {
        OdfCircleElement  nCircle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCircleElement.class);
        this.appendChild( nCircle);
        return  nCircle;
    }                   
               
    /**
    * Create child element {@odfLink draw:ellipse}.
    *
    *@return   return  the element {@odfLink draw:ellipse}
    */
    public OdfEllipseElement createEllipseElement()
    {
        OdfEllipseElement  nEllipse = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEllipseElement.class);
        this.appendChild( nEllipse);
        return  nEllipse;
    }                   
               
    /**
    * Create child element {@odfLink draw:g}.
    *
    *@return   return  the element {@odfLink draw:g}
    */
    public OdfGroupElement createGroupElement()
    {
        OdfGroupElement  nGroup = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGroupElement.class);
        this.appendChild( nGroup);
        return  nGroup;
    }                   
               
    /**
    * Create child element {@odfLink draw:page-thumbnail}.
    *
    *@return   return  the element {@odfLink draw:page-thumbnail}
    */
    public OdfPageThumbnailElement createPageThumbnailElement()
    {
        OdfPageThumbnailElement  nPageThumbnail = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageThumbnailElement.class);
        this.appendChild( nPageThumbnail);
        return  nPageThumbnail;
    }                   
               
    /**
    * Create child element {@odfLink draw:frame}.
    *
    *@return   return  the element {@odfLink draw:frame}
    */
    public OdfFrameElement createFrameElement()
    {
        OdfFrameElement  nFrame = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFrameElement.class);
        this.appendChild( nFrame);
        return  nFrame;
    }                   
               
    /**
    * Create child element {@odfLink draw:measure}.
    *
    *@param x1  the attribute's type is String
    *@param y1  the attribute's type is String
    *@param x2  the attribute's type is String
    *@param y2  the attribute's type is String
    *@return   return  the element {@odfLink draw:measure}
    */
    public org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement createdrawMeasureElement(org.odftoolkit.odfdom.dom.type.OdfLength   x1, org.odftoolkit.odfdom.dom.type.OdfLength   y1, org.odftoolkit.odfdom.dom.type.OdfLength   x2, org.odftoolkit.odfdom.dom.type.OdfLength   y2)
    {
        org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement  nMeasure = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement.class);
        nMeasure.setX1( x1);
        nMeasure.setY1( y1);
        nMeasure.setX2( x2);
        nMeasure.setY2( y2);
        this.appendChild( nMeasure);
        return  nMeasure;      
    }
    
    /**
    * Create child element {@odfLink draw:caption}.
    *
    *@return   return  the element {@odfLink draw:caption}
    */
    public OdfCaptionElement createCaptionElement()
    {
        OdfCaptionElement  nCaption = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCaptionElement.class);
        this.appendChild( nCaption);
        return  nCaption;
    }                   
               
    /**
    * Create child element {@odfLink draw:connector}.
    *
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:connector}
    */
    public OdfConnectorElement createConnectorElement(Integer   viewBox)
    {
        OdfConnectorElement  nConnector = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConnectorElement.class);
        nConnector.setViewBox( viewBox);
        this.appendChild( nConnector);
        return  nConnector;      
    }
    
    /**
    * Create child element {@odfLink draw:control}.
    *
    *@param control  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@return   return  the element {@odfLink draw:control}
    */
    public OdfControlElement createControlElement(org.odftoolkit.odfdom.dom.type.OdfId   control)
    {
        OdfControlElement  nControl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfControlElement.class);
        nControl.setControl( control);
        this.appendChild( nControl);
        return  nControl;      
    }
    
    /**
    * Create child element {@odfLink dr3d:scene}.
    *
    *@return   return  the element {@odfLink dr3d:scene}
    */
    public OdfSceneElement createSceneElement()
    {
        OdfSceneElement  nScene = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSceneElement.class);
        this.appendChild( nScene);
        return  nScene;
    }                   
               
    /**
    * Create child element {@odfLink draw:custom-shape}.
    *
    *@return   return  the element {@odfLink draw:custom-shape}
    */
    public OdfCustomShapeElement createCustomShapeElement()
    {
        OdfCustomShapeElement  nCustomShape = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCustomShapeElement.class);
        this.appendChild( nCustomShape);
        return  nCustomShape;
    }                   
               
    /**
    * Create child element {@odfLink draw:a}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink draw:a}
    */
    public org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement createdrawHyperlinkElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement  nHyperlink = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement.class);
        nHyperlink.setHref( href);
        this.appendChild( nHyperlink);
        return  nHyperlink;      
    }
    
}
