/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.draw.OdfAlignType;
import org.odftoolkit.odfdom.dom.type.draw.OdfEscapeDirectionType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:glue-point}.
 *
 */
public abstract class OdfGluePointElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "glue-point" );

    /**
     * Create the instance of OdfGluePointElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfGluePointElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:glue-point}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfGluePointElement}
     *
     *@param drawid  The mandatory attribute {@attributeName  draw:drawid}" 
     *@param x  The mandatory attribute {@attributeName  svg:x}" 
     *@param y  The mandatory attribute {@attributeName  svg:y}" 
     *@param escapeDirection  The mandatory attribute {@attributeName  draw:escape-direction}" 
     *
     */
    public void init(OdfNonNegativeInteger drawid, OdfLength x, OdfLength y, OdfEscapeDirectionType escapeDirection)
    {
        setDrawid( drawid );
        setX( x );
        setY( y );
        setEscapeDirection( escapeDirection );
    }

    /**
     * Get value of attribute {@attributeName draw:id}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getDrawid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "id" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:id}.
     *
     *@param  drawid    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setDrawid( OdfNonNegativeInteger drawid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "id" ), drawid.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:x}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x}.
     *
     *@param  x    the attribute's type is OdfLength
     */ 
     public void setX( OdfLength x )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ), x.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y}.
     *
     *@param  y    the attribute's type is OdfLength
     */ 
     public void setY( OdfLength y )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ), y.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:align}.
     *
     *@return return the attribute which type is OdfAlignType
     */
    public OdfAlignType getAlign()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "align" ) );
        return OdfAlignType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:align}.
     *
     *@param  align    the attribute's type is OdfAlignType
     */ 
     public void setAlign( OdfAlignType align )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "align" ), align.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:escape-direction}.
     *
     *@return return the attribute which type is OdfEscapeDirectionType
     */
    public OdfEscapeDirectionType getEscapeDirection()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "escape-direction" ) );
        return OdfEscapeDirectionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:escape-direction}.
     *
     *@param  escapeDirection    the attribute's type is OdfEscapeDirectionType
     */ 
     public void setEscapeDirection( OdfEscapeDirectionType escapeDirection )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "escape-direction" ), escapeDirection.toString() );
    }

}
