/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.OdfPercent;
import org.odftoolkit.odfdom.dom.type.OdfId;
import org.odftoolkit.odfdom.dom.type.OdfPresentationClasses;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

import org.odftoolkit.odfdom.dom.element.table.OdfTableElement;
import org.odftoolkit.odfdom.dom.element.office.OdfEventListenersElement;
import org.odftoolkit.odfdom.dom.type.draw.OdfEscapeDirectionType;
import org.odftoolkit.odfdom.dom.element.svg.OdfTitleElement;
import org.odftoolkit.odfdom.dom.element.svg.OdfDescElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:frame}.
 *
 */
public abstract class OdfFrameElement extends OdfShapeElementBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "frame" );

    /**
     * Create the instance of OdfFrameElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfFrameElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:frame}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName draw:layer}.
     *
     *@return return the attribute which type is String
     */
    public String getLayer()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "layer" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:layer}.
     *
     *@param  layer    the attribute's type is String
     */ 
     public void setLayer( String layer )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "layer" ), layer );
    }

    /**
     * Get value of attribute {@attributeName draw:transform}.
     *
     *@return return the attribute which type is String
     */
    public String getTransform()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "transform" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:transform}.
     *
     *@param  transform    the attribute's type is String
     */ 
     public void setTransform( String transform )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "transform" ), transform );
    }

    /**
     * Get value of attribute {@attributeName draw:text-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getTextStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:text-style-name}.
     *
     *@param  textStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setTextStyleName( OdfStyleNameRef textStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-style-name" ), textStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:x}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x}.
     *
     *@param  x    the attribute's type is OdfLength
     */ 
     public void setX( OdfLength x )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ), x.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y}.
     *
     *@param  y    the attribute's type is OdfLength
     */ 
     public void setY( OdfLength y )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ), y.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:width}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:width}.
     *
     *@param  width    the attribute's type is OdfLength
     */ 
     public void setWidth( OdfLength width )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ), width.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:height}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:height}.
     *
     *@param  height    the attribute's type is OdfLength
     */ 
     public void setHeight( OdfLength height )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ), height.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:rel-width}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getRelWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rel-width" ) );
        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:rel-width}.
     *
     *@param  relWidth    the attribute's type is OdfPercent
     */ 
     public void setRelWidth( OdfPercent relWidth )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rel-width" ), relWidth.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:rel-height}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getRelHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rel-height" ) );
        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:rel-height}.
     *
     *@param  relHeight    the attribute's type is OdfPercent
     */ 
     public void setRelHeight( OdfPercent relHeight )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rel-height" ), relHeight.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:caption-id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getCaptionId()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "caption-id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:caption-id}.
     *
     *@param  captionId    the attribute's type is OdfId
     */ 
     public void setCaptionId( OdfId captionId )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "caption-id" ), captionId.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:class}.
     *
     *@return return the attribute which type is OdfPresentationClasses
     */
    public OdfPresentationClasses getPresentationClass()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "class" ) );
        return OdfPresentationClasses.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:class}.
     *
     *@param  presentationClass    the attribute's type is OdfPresentationClasses
     */ 
     public void setPresentationClass( OdfPresentationClasses presentationClass )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "class" ), presentationClass.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:placeholder}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getPlaceholder()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "placeholder" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:placeholder}.
     *
     *@param  isPlaceholder    the attribute's type is OdfBoolean
     */ 
     public void setPlaceholder( OdfBoolean isPlaceholder )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "placeholder" ), isPlaceholder.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:user-transformed}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUserTransformed()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "user-transformed" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:user-transformed}.
     *
     *@param  isUserTransformed    the attribute's type is OdfBoolean
     */ 
     public void setUserTransformed( OdfBoolean isUserTransformed )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "user-transformed" ), isUserTransformed.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:copy-of}.
     *
     *@return return the attribute which type is String
     */
    public String getCopyOf()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "copy-of" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:copy-of}.
     *
     *@param  copyOf    the attribute's type is String
     */ 
     public void setCopyOf( String copyOf )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "copy-of" ), copyOf );
    }

    /**
    * Create child element {@odfLink draw:text-box}.
    *
    *@return   return  the element {@odfLink draw:text-box}
    */
    public OdfTextBoxElement createTextBoxElement()
    {
        OdfTextBoxElement  nTextBox = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextBoxElement.class);
        this.appendChild( nTextBox);
        return  nTextBox;
    }                   
               
    /**
    * Create child element {@odfLink draw:image}.
    *
    *@return   return  the element {@odfLink draw:image}
    */
    public OdfImageElement createImageElement()
    {
        OdfImageElement  nImage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfImageElement.class);
        this.appendChild( nImage);
        return  nImage;
    }                   
               
    /**
    * Create child element {@odfLink draw:object}.
    *
    *@return   return  the element {@odfLink draw:object}
    */
    public OdfObjectElement createObjectElement()
    {
        OdfObjectElement  nObject = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfObjectElement.class);
        this.appendChild( nObject);
        return  nObject;
    }                   
               
    /**
    * Create child element {@odfLink draw:object-ole}.
    *
    *@return   return  the element {@odfLink draw:object-ole}
    */
    public OdfObjectOleElement createObjectOleElement()
    {
        OdfObjectOleElement  nObjectOle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfObjectOleElement.class);
        this.appendChild( nObjectOle);
        return  nObjectOle;
    }                   
               
    /**
    * Create child element {@odfLink draw:applet}.
    *
    *@return   return  the element {@odfLink draw:applet}
    */
    public OdfAppletElement createAppletElement()
    {
        OdfAppletElement  nApplet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAppletElement.class);
        this.appendChild( nApplet);
        return  nApplet;
    }                   
               
    /**
    * Create child element {@odfLink draw:floating-frame}.
    *
    *@return   return  the element {@odfLink draw:floating-frame}
    */
    public OdfFloatingFrameElement createFloatingFrameElement()
    {
        OdfFloatingFrameElement  nFloatingFrame = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFloatingFrameElement.class);
        this.appendChild( nFloatingFrame);
        return  nFloatingFrame;
    }                   
               
    /**
    * Create child element {@odfLink draw:plugin}.
    *
    *@return   return  the element {@odfLink draw:plugin}
    */
    public OdfPluginElement createPluginElement()
    {
        OdfPluginElement  nPlugin = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPluginElement.class);
        this.appendChild( nPlugin);
        return  nPlugin;
    }                   
               
    /**
    * Create child element {@odfLink table:table}.
    *
    *@return   return  the element {@odfLink table:table}
    */
    public OdfTableElement createTableElement()
    {
        OdfTableElement  nTable = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableElement.class);
        this.appendChild( nTable);
        return  nTable;
    }                   
               
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
    /**
    * Create child element {@odfLink draw:glue-point}.
    *
    *@param drawid  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@param x  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param escapeDirection     the attribute's type is OdfEscapeDirectionType, see {@attributeName  draw:escape-direction} at specification
    *@return   return  the element {@odfLink draw:glue-point}
    */
    public OdfGluePointElement createGluePointElement(org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   drawid, org.odftoolkit.odfdom.dom.type.OdfLength   x, org.odftoolkit.odfdom.dom.type.OdfLength   y, OdfEscapeDirectionType   escapeDirection)
    {
        OdfGluePointElement  nGluePoint = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGluePointElement.class);
        nGluePoint.setDrawid( drawid);
        nGluePoint.setX( x);
        nGluePoint.setY( y);
        nGluePoint.setEscapeDirection( escapeDirection);
        this.appendChild( nGluePoint);
        return  nGluePoint;      
    }
    
    /**
    * Create child element {@odfLink draw:image-map}.
    *
    *@return   return  the element {@odfLink draw:image-map}
    */
    public OdfImageMapElement createImageMapElement()
    {
        OdfImageMapElement  nImageMap = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfImageMapElement.class);
        this.appendChild( nImageMap);
        return  nImageMap;
    }                   
               
    /**
    * Create child element {@odfLink svg:title}.
    *
    *@return   return  the element {@odfLink svg:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink svg:desc}.
    *
    *@return   return  the element {@odfLink svg:desc}
    */
    public OdfDescElement createDescElement()
    {
        OdfDescElement  nDesc = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescElement.class);
        this.appendChild( nDesc);
        return  nDesc;
    }                   
               
    /**
    * Create child element {@odfLink draw:contour-polygon}.
    *
    *@param recreateOnEdit  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfBoolean
    *@param viewBox Integer   
    *@param points String   
    *@return   return  the element {@odfLink draw:contour-polygon}
    */
    public OdfContourPolygonElement createContourPolygonElement(org.odftoolkit.odfdom.dom.type.OdfBoolean   recreateOnEdit, Integer   viewBox, String   points)
    {
        OdfContourPolygonElement  nContourPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfContourPolygonElement.class);
        nContourPolygon.setRecreateOnEdit( recreateOnEdit);
        nContourPolygon.setViewBox( viewBox);
        nContourPolygon.setPoints( points);
        this.appendChild( nContourPolygon);
        return  nContourPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:contour-path}.
    *
    *@param recreateOnEdit  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfBoolean
    *@param viewBox Integer   
    *@param d String   
    *@return   return  the element {@odfLink draw:contour-path}
    */
    public OdfContourPathElement createContourPathElement(org.odftoolkit.odfdom.dom.type.OdfBoolean   recreateOnEdit, Integer   viewBox, String   d)
    {
        OdfContourPathElement  nContourPath = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfContourPathElement.class);
        nContourPath.setRecreateOnEdit( recreateOnEdit);
        nContourPath.setViewBox( viewBox);
        nContourPath.setD( d);
        this.appendChild( nContourPath);
        return  nContourPath;      
    }
    
}
