/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:fill-image}.
 *
 */
public abstract class OdfFillImageElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "fill-image" );

    /**
     * Create the instance of OdfFillImageElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfFillImageElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:fill-image}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfFillImageElement}
     *
     *@param name  The mandatory attribute {@attributeName  draw:name}" 
     *@param href  The mandatory attribute {@attributeName  xlink:href}" 
     *
     */
    public void init(OdfStyleName name, OdfAnyURI href)
    {
        setName( name );
        setHref( href );
    }

    /**
     * Get value of attribute {@attributeName draw:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:display-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDisplayName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display-name" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:display-name}.
     *
     *@param  displayName    the attribute's type is String
     */ 
     public void setDisplayName( String displayName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display-name" ), displayName );
    }

    /**
     * Get value of attribute {@attributeName svg:width}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:width}.
     *
     *@param  width    the attribute's type is OdfLength
     */ 
     public void setWidth( OdfLength width )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ), width.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:height}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:height}.
     *
     *@param  height    the attribute's type is OdfLength
     */ 
     public void setHeight( OdfLength height )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ), height.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ), "embed" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "actuate" ), "onLoad" );
    }

}
