/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfPercent;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.dr3d.OdfShadeModeType;
import org.odftoolkit.odfdom.dom.type.dr3d.OdfProjectionType;
import org.odftoolkit.odfdom.dom.type.draw.OdfGluePointType;
import org.odftoolkit.odfdom.dom.type.draw.OdfTextPathModeType;
import org.odftoolkit.odfdom.dom.type.draw.OdfTextPathScaleType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:enhanced-geometry}.
 *
 */
public abstract class OdfEnhancedGeometryElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "enhanced-geometry" );

    /**
     * Create the instance of OdfEnhancedGeometryElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfEnhancedGeometryElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:enhanced-geometry}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName draw:type}.
     *
     *@return return the attribute which type is String
     */
    public String getType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "type" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "non-primitive";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:type}.
     *
     *@param  type    the attribute's type is String
     */ 
     public void setType( String type )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "type" ), type );
    }

    /**
     * Get value of attribute {@attributeName svg:viewBox}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getViewBox()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "viewBox" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:viewBox}.
     *
     *@param  viewBox    the attribute's type is Integer
     */ 
     public void setViewBox( Integer viewBox )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "viewBox" ), viewBox.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:mirror-vertical}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getMirrorVertical()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "mirror-vertical" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:mirror-vertical}.
     *
     *@param  isMirrorVertical    the attribute's type is OdfBoolean
     */ 
     public void setMirrorVertical( OdfBoolean isMirrorVertical )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "mirror-vertical" ), isMirrorVertical.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:mirror-horizontal}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getMirrorHorizontal()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "mirror-horizontal" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:mirror-horizontal}.
     *
     *@param  isMirrorHorizontal    the attribute's type is OdfBoolean
     */ 
     public void setMirrorHorizontal( OdfBoolean isMirrorHorizontal )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "mirror-horizontal" ), isMirrorHorizontal.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:text-rotate-angle}.
     *
     *@return return the attribute which type is String
     */
    public String getTextRotateAngle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-rotate-angle" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:text-rotate-angle}.
     *
     *@param  textRotateAngle    the attribute's type is String
     */ 
     public void setTextRotateAngle( String textRotateAngle )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-rotate-angle" ), textRotateAngle );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-allowed}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getExtrusionAllowed()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-allowed" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-allowed}.
     *
     *@param  isExtrusionAllowed    the attribute's type is OdfBoolean
     */ 
     public void setExtrusionAllowed( OdfBoolean isExtrusionAllowed )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-allowed" ), isExtrusionAllowed.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:text-path-allowed}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getTextPathAllowed()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-path-allowed" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:text-path-allowed}.
     *
     *@param  isTextPathAllowed    the attribute's type is OdfBoolean
     */ 
     public void setTextPathAllowed( OdfBoolean isTextPathAllowed )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-path-allowed" ), isTextPathAllowed.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:concentric-gradient-fill-allowed}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getConcentricGradientFillAllowed()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "concentric-gradient-fill-allowed" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:concentric-gradient-fill-allowed}.
     *
     *@param  isConcentricGradientFillAllowed    the attribute's type is OdfBoolean
     */ 
     public void setConcentricGradientFillAllowed( OdfBoolean isConcentricGradientFillAllowed )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "concentric-gradient-fill-allowed" ), isConcentricGradientFillAllowed.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getExtrusion()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion}.
     *
     *@param  isExtrusion    the attribute's type is OdfBoolean
     */ 
     public void setExtrusion( OdfBoolean isExtrusion )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion" ), isExtrusion.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-brightness}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getExtrusionBrightness()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-brightness" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "33%";
        }

        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-brightness}.
     *
     *@param  extrusionBrightness    the attribute's type is OdfPercent
     */ 
     public void setExtrusionBrightness( OdfPercent extrusionBrightness )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-brightness" ), extrusionBrightness.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-depth}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getExtrusionDepth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-depth" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "36pt 0";
        }

        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-depth}.
     *
     *@param  extrusionDepth    the attribute's type is OdfLength
     */ 
     public void setExtrusionDepth( OdfLength extrusionDepth )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-depth" ), extrusionDepth.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-diffusion}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getExtrusionDiffusion()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-diffusion" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0%";
        }

        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-diffusion}.
     *
     *@param  extrusionDiffusion    the attribute's type is OdfPercent
     */ 
     public void setExtrusionDiffusion( OdfPercent extrusionDiffusion )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-diffusion" ), extrusionDiffusion.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-number-of-line-segments}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getExtrusionNumberOfLineSegments()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-number-of-line-segments" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "30";
        }

        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-number-of-line-segments}.
     *
     *@param  extrusionNumberOfLineSegments    the attribute's type is Integer
     */ 
     public void setExtrusionNumberOfLineSegments( Integer extrusionNumberOfLineSegments )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-number-of-line-segments" ), extrusionNumberOfLineSegments.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-light-face}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getExtrusionLightFace()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-light-face" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-light-face}.
     *
     *@param  isExtrusionLightFace    the attribute's type is OdfBoolean
     */ 
     public void setExtrusionLightFace( OdfBoolean isExtrusionLightFace )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-light-face" ), isExtrusionLightFace.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-first-light-harsh}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getExtrusionFirstLightHarsh()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-first-light-harsh" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-first-light-harsh}.
     *
     *@param  isExtrusionFirstLightHarsh    the attribute's type is OdfBoolean
     */ 
     public void setExtrusionFirstLightHarsh( OdfBoolean isExtrusionFirstLightHarsh )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-first-light-harsh" ), isExtrusionFirstLightHarsh.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-second-light-harsh}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getExtrusionSecondLightHarsh()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-second-light-harsh" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-second-light-harsh}.
     *
     *@param  isExtrusionSecondLightHarsh    the attribute's type is OdfBoolean
     */ 
     public void setExtrusionSecondLightHarsh( OdfBoolean isExtrusionSecondLightHarsh )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-second-light-harsh" ), isExtrusionSecondLightHarsh.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-first-light-level}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getExtrusionFirstLightLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-first-light-level" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "66%";
        }

        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-first-light-level}.
     *
     *@param  extrusionFirstLightLevel    the attribute's type is OdfPercent
     */ 
     public void setExtrusionFirstLightLevel( OdfPercent extrusionFirstLightLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-first-light-level" ), extrusionFirstLightLevel.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-second-light-level}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getExtrusionSecondLightLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-second-light-level" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "66%";
        }

        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-second-light-level}.
     *
     *@param  extrusionSecondLightLevel    the attribute's type is OdfPercent
     */ 
     public void setExtrusionSecondLightLevel( OdfPercent extrusionSecondLightLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-second-light-level" ), extrusionSecondLightLevel.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-first-light-direction}.
     *
     *@return return the attribute which type is String
     */
    public String getExtrusionFirstLightDirection()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-first-light-direction" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "(5 0 1)";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-first-light-direction}.
     *
     *@param  extrusionFirstLightDirection    the attribute's type is String
     */ 
     public void setExtrusionFirstLightDirection( String extrusionFirstLightDirection )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-first-light-direction" ), extrusionFirstLightDirection );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-second-light-direction}.
     *
     *@return return the attribute which type is String
     */
    public String getExtrusionSecondLightDirection()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-second-light-direction" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "(-5 0 1)";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-second-light-direction}.
     *
     *@param  extrusionSecondLightDirection    the attribute's type is String
     */ 
     public void setExtrusionSecondLightDirection( String extrusionSecondLightDirection )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-second-light-direction" ), extrusionSecondLightDirection );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-metal}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getExtrusionMetal()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-metal" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-metal}.
     *
     *@param  isExtrusionMetal    the attribute's type is OdfBoolean
     */ 
     public void setExtrusionMetal( OdfBoolean isExtrusionMetal )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-metal" ), isExtrusionMetal.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:shade-mode}.
     *
     *@return return the attribute which type is OdfShadeModeType
     */
    public OdfShadeModeType getShadeMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "shade-mode" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "flat";
        }

        return OdfShadeModeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:shade-mode}.
     *
     *@param  shadeMode    the attribute's type is OdfShadeModeType
     */ 
     public void setShadeMode( OdfShadeModeType shadeMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "shade-mode" ), shadeMode.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-rotation-angle}.
     *
     *@return return the attribute which type is String
     */
    public String getExtrusionRotationAngle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-rotation-angle" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0 0";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-rotation-angle}.
     *
     *@param  extrusionRotationAngle    the attribute's type is String
     */ 
     public void setExtrusionRotationAngle( String extrusionRotationAngle )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-rotation-angle" ), extrusionRotationAngle );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-rotation-center}.
     *
     *@return return the attribute which type is String
     */
    public String getExtrusionRotationCenter()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-rotation-center" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-rotation-center}.
     *
     *@param  extrusionRotationCenter    the attribute's type is String
     */ 
     public void setExtrusionRotationCenter( String extrusionRotationCenter )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-rotation-center" ), extrusionRotationCenter );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-shininess}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getExtrusionShininess()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-shininess" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "50%";
        }

        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-shininess}.
     *
     *@param  extrusionShininess    the attribute's type is OdfPercent
     */ 
     public void setExtrusionShininess( OdfPercent extrusionShininess )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-shininess" ), extrusionShininess.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-skew}.
     *
     *@return return the attribute which type is Double
     */
    public Double getExtrusionSkew()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-skew" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "50 45";
        }

        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-skew}.
     *
     *@param  extrusionSkew    the attribute's type is Double
     */ 
     public void setExtrusionSkew( Double extrusionSkew )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-skew" ), extrusionSkew.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-specularity}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getExtrusionSpecularity()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-specularity" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0%";
        }

        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-specularity}.
     *
     *@param  extrusionSpecularity    the attribute's type is OdfPercent
     */ 
     public void setExtrusionSpecularity( OdfPercent extrusionSpecularity )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-specularity" ), extrusionSpecularity.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:projection}.
     *
     *@return return the attribute which type is OdfProjectionType
     */
    public OdfProjectionType getProjection()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "projection" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "parallel";
        }

        return OdfProjectionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:projection}.
     *
     *@param  projection    the attribute's type is OdfProjectionType
     */ 
     public void setProjection( OdfProjectionType projection )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "projection" ), projection.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-viewpoint}.
     *
     *@return return the attribute which type is String
     */
    public String getExtrusionViewpoint()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-viewpoint" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "3.5cm -3.5cm 25cm";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-viewpoint}.
     *
     *@param  extrusionViewpoint    the attribute's type is String
     */ 
     public void setExtrusionViewpoint( String extrusionViewpoint )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-viewpoint" ), extrusionViewpoint );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-origin}.
     *
     *@return return the attribute which type is Double
     */
    public Double getExtrusionOrigin()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-origin" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0.5 -0.5";
        }

        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-origin}.
     *
     *@param  extrusionOrigin    the attribute's type is Double
     */ 
     public void setExtrusionOrigin( Double extrusionOrigin )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-origin" ), extrusionOrigin.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:extrusion-color}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getExtrusionColor()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-color" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:extrusion-color}.
     *
     *@param  isExtrusionColor    the attribute's type is OdfBoolean
     */ 
     public void setExtrusionColor( OdfBoolean isExtrusionColor )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "extrusion-color" ), isExtrusionColor.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:enhanced-path}.
     *
     *@return return the attribute which type is String
     */
    public String getEnhancedPath()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "enhanced-path" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:enhanced-path}.
     *
     *@param  enhancedPath    the attribute's type is String
     */ 
     public void setEnhancedPath( String enhancedPath )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "enhanced-path" ), enhancedPath );
    }

    /**
     * Get value of attribute {@attributeName draw:path-stretchpoint-x}.
     *
     *@return return the attribute which type is Double
     */
    public Double getPathStretchpointX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "path-stretchpoint-x" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0";
        }

        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:path-stretchpoint-x}.
     *
     *@param  pathStretchpointX    the attribute's type is Double
     */ 
     public void setPathStretchpointX( Double pathStretchpointX )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "path-stretchpoint-x" ), pathStretchpointX.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:path-stretchpoint-y}.
     *
     *@return return the attribute which type is Double
     */
    public Double getPathStretchpointY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "path-stretchpoint-y" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0";
        }

        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:path-stretchpoint-y}.
     *
     *@param  pathStretchpointY    the attribute's type is Double
     */ 
     public void setPathStretchpointY( Double pathStretchpointY )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "path-stretchpoint-y" ), pathStretchpointY.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:text-areas}.
     *
     *@return return the attribute which type is String
     */
    public String getTextAreas()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-areas" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:text-areas}.
     *
     *@param  textAreas    the attribute's type is String
     */ 
     public void setTextAreas( String textAreas )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-areas" ), textAreas );
    }

    /**
     * Get value of attribute {@attributeName draw:glue-points}.
     *
     *@return return the attribute which type is String
     */
    public String getGluePoints()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "glue-points" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:glue-points}.
     *
     *@param  gluePoints    the attribute's type is String
     */ 
     public void setGluePoints( String gluePoints )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "glue-points" ), gluePoints );
    }

    /**
     * Get value of attribute {@attributeName draw:glue-point-type}.
     *
     *@return return the attribute which type is OdfGluePointType
     */
    public OdfGluePointType getGluePointType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "glue-point-type" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "none";
        }

        return OdfGluePointType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:glue-point-type}.
     *
     *@param  gluePointType    the attribute's type is OdfGluePointType
     */ 
     public void setGluePointType( OdfGluePointType gluePointType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "glue-point-type" ), gluePointType.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:glue-point-leaving-directions}.
     *
     *@return return the attribute which type is String
     */
    public String getGluePointLeavingDirections()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "glue-point-leaving-directions" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:glue-point-leaving-directions}.
     *
     *@param  gluePointLeavingDirections    the attribute's type is String
     */ 
     public void setGluePointLeavingDirections( String gluePointLeavingDirections )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "glue-point-leaving-directions" ), gluePointLeavingDirections );
    }

    /**
     * Get value of attribute {@attributeName draw:text-path}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getTextPath()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-path" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:text-path}.
     *
     *@param  isTextPath    the attribute's type is OdfBoolean
     */ 
     public void setTextPath( OdfBoolean isTextPath )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-path" ), isTextPath.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:text-path-mode}.
     *
     *@return return the attribute which type is OdfTextPathModeType
     */
    public OdfTextPathModeType getTextPathMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-path-mode" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "normal";
        }

        return OdfTextPathModeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:text-path-mode}.
     *
     *@param  textPathMode    the attribute's type is OdfTextPathModeType
     */ 
     public void setTextPathMode( OdfTextPathModeType textPathMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-path-mode" ), textPathMode.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:text-path-scale}.
     *
     *@return return the attribute which type is OdfTextPathScaleType
     */
    public OdfTextPathScaleType getTextPathScale()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-path-scale" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "path";
        }

        return OdfTextPathScaleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:text-path-scale}.
     *
     *@param  textPathScale    the attribute's type is OdfTextPathScaleType
     */ 
     public void setTextPathScale( OdfTextPathScaleType textPathScale )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-path-scale" ), textPathScale.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:text-path-same-letter-heights}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getTextPathSameLetterHeights()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-path-same-letter-heights" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:text-path-same-letter-heights}.
     *
     *@param  isTextPathSameLetterHeights    the attribute's type is OdfBoolean
     */ 
     public void setTextPathSameLetterHeights( OdfBoolean isTextPathSameLetterHeights )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-path-same-letter-heights" ), isTextPathSameLetterHeights.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:modifiers}.
     *
     *@return return the attribute which type is String
     */
    public String getModifiers()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "modifiers" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:modifiers}.
     *
     *@param  modifiers    the attribute's type is String
     */ 
     public void setModifiers( String modifiers )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "modifiers" ), modifiers );
    }

    /**
    * Create child element {@odfLink draw:equation}.
    *
    *@return   return  the element {@odfLink draw:equation}
    */
    public OdfEquationElement createEquationElement()
    {
        OdfEquationElement  nEquation = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEquationElement.class);
        this.appendChild( nEquation);
        return  nEquation;
    }                   
               
    /**
    * Create child element {@odfLink draw:handle}.
    *
    *@param handlePosition String   
    *@return   return  the element {@odfLink draw:handle}
    */
    public OdfHandleElement createHandleElement(String   handlePosition)
    {
        OdfHandleElement  nHandle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHandleElement.class);
        nHandle.setHandlePosition( handlePosition);
        this.appendChild( nHandle);
        return  nHandle;      
    }
    
}
