/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfLength;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:contour-path}.
 *
 */
public abstract class OdfContourPathElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "contour-path" );

    /**
     * Create the instance of OdfContourPathElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfContourPathElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:contour-path}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfContourPathElement}
     *
     *@param recreateOnEdit  The mandatory attribute {@attributeName  draw:recreate-on-edit}" 
     *@param viewBox  The mandatory attribute {@attributeName  svg:viewBox}" 
     *@param d  The mandatory attribute {@attributeName  svg:d}" 
     *
     */
    public void init(OdfBoolean recreateOnEdit, Integer viewBox, String d)
    {
        setRecreateOnEdit( recreateOnEdit );
        setViewBox( viewBox );
        setD( d );
    }

    /**
     * Get value of attribute {@attributeName draw:recreate-on-edit}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getRecreateOnEdit()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "recreate-on-edit" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:recreate-on-edit}.
     *
     *@param  isRecreateOnEdit    the attribute's type is OdfBoolean
     */ 
     public void setRecreateOnEdit( OdfBoolean isRecreateOnEdit )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "recreate-on-edit" ), isRecreateOnEdit.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:width}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:width}.
     *
     *@param  width    the attribute's type is OdfLength
     */ 
     public void setWidth( OdfLength width )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ), width.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:height}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:height}.
     *
     *@param  height    the attribute's type is OdfLength
     */ 
     public void setHeight( OdfLength height )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ), height.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:viewBox}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getViewBox()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "viewBox" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:viewBox}.
     *
     *@param  viewBox    the attribute's type is Integer
     */ 
     public void setViewBox( Integer viewBox )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "viewBox" ), viewBox.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:d}.
     *
     *@return return the attribute which type is String
     */
    public String getD()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SVG, "d" ) );
    }

    /**
     * Set value of attribute {@attributeName svg:d}.
     *
     *@param  d    the attribute's type is String
     */ 
     public void setD( String d )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "d" ), d );
    }

}
